/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.spi.AbstractSpiHelper;
import com.cyberway.mp.bbc.spi.bean.SpiImplDefinition;
import com.cyberway.mp.bbc.spi.bean.SpiPointDefinition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultSpiHelper
extends AbstractSpiHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<SpiPointDefinition> spiPointDefinitions;
    private final List<SpiImplDefinition> spiImplDefinitions;
    private final ConfigurationApi configurationApi;

    public DefaultSpiHelper(List<SpiPointDefinition> spiPointDefinitions, List<SpiImplDefinition> spiImplDefinitions, ConfigurationApi configurationApi) {
        this.spiPointDefinitions = spiPointDefinitions;
        this.spiImplDefinitions = spiImplDefinitions;
        this.configurationApi = configurationApi;
    }

    @Override
    public void postToBasicDataCenter() {
        this.logger.info("start to post spi configuration");
        long startTime = System.currentTimeMillis();
        ArrayList<SpiRegisterDto> spiRegisterDtoList = new ArrayList<SpiRegisterDto>(this.spiImplDefinitions.size());
        if (!CollectionUtils.isEmpty(this.spiPointDefinitions)) {
            for (SpiPointDefinition spiPointDefinition : this.spiPointDefinitions) {
                SpiRegisterDto dto = this.buildAndCheckSpiRegisterDto(spiPointDefinition, this.spiImplDefinitions);
                if (null == dto) continue;
                spiRegisterDtoList.add(dto);
            }
        }
        if (!CollectionUtils.isEmpty(spiRegisterDtoList)) {
            this.configurationApi.spiRegister(spiRegisterDtoList);
        }
        this.logger.info("post spi configuration finish,size:{},cost:{}ms", (Object)spiRegisterDtoList.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    @Override
    public String getConfig(Class<?> type, LevelType levelType, long levelId) {
        SpiPointDefinition spiPointDefinition = null;
        if (!CollectionUtils.isEmpty(this.spiPointDefinitions)) {
            spiPointDefinition = this.spiPointDefinitions.stream().filter(def -> def.getType() == type).findFirst().orElse(null);
        }
        if (null == spiPointDefinition) {
            throw new IllegalArgumentException("Missing " + type + " SpiPointDefinition,make sure @EnableSPI.basePackages including your @SPIPoint class package");
        }
        return this.configurationApi.getStringValue(spiPointDefinition.getFunctionCode(), spiPointDefinition.getCode(), levelType, Long.valueOf(levelId));
    }
}

