/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi;

import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.spi.AbstractSpiHelper;
import com.cyberway.mp.bbc.spi.LocalSpiProperties;
import com.cyberway.mp.bbc.spi.bean.SpiImplDefinition;
import com.cyberway.mp.bbc.spi.bean.SpiPointDefinition;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class LocalSpiHelper
extends AbstractSpiHelper {
    private static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    private final List<SpiPointDefinition> spiPointDefinitions;
    private final List<SpiImplDefinition> spiImplDefinitions;
    private final LocalSpiProperties localSPIProperties;

    public LocalSpiHelper(List<SpiPointDefinition> spiPointDefinitions, List<SpiImplDefinition> spiImplDefinitions, LocalSpiProperties localSpiProperties) {
        this.spiPointDefinitions = spiPointDefinitions;
        this.spiImplDefinitions = spiImplDefinitions;
        this.localSPIProperties = localSpiProperties;
    }

    @Override
    public void postToBasicDataCenter() {
        this.validateSpiPointDefinitions();
        if (!CollectionUtils.isEmpty(this.spiPointDefinitions)) {
            for (SpiPointDefinition spiPointDefinition : this.spiPointDefinitions) {
                SpiRegisterDto dto = this.buildAndCheckSpiRegisterDto(spiPointDefinition, this.spiImplDefinitions);
                if (null == dto) continue;
                this.putSpiCache(dto.getFunctionGroupCode(), dto.getConfigurationKey(), dto.getDefaultValue(), LevelType.GLOBAL, 0L);
            }
        }
    }

    private void validateSpiPointDefinitions() {
        HashMap<CallSite, SpiPointDefinition> definitionMap = new HashMap<CallSite, SpiPointDefinition>(this.spiPointDefinitions.size());
        for (SpiPointDefinition spiPointDefinition : this.spiPointDefinitions) {
            String key = spiPointDefinition.getFunctionCode() + "_" + spiPointDefinition.getCode();
            if (definitionMap.containsKey(key)) {
                throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684configurationKey:" + key);
            }
            definitionMap.put((CallSite)((Object)key), spiPointDefinition);
        }
    }

    @Override
    public String getConfig(Class<?> type, LevelType levelType, long levelId) {
        LocalSpiProperties.LocalSpiConfig config;
        SpiPointDefinition spiPointDefinition;
        SpiPointDefinition spiPointDefinition2 = spiPointDefinition = this.spiPointDefinitions == null ? null : (SpiPointDefinition)this.spiPointDefinitions.stream().filter(def -> def.getType() == type).findFirst().orElse(null);
        if (null == spiPointDefinition) {
            throw new IllegalArgumentException("Missing " + type + " SpiPointDefinition,make sure @EnableSPI.basePackages including your @SPIPoint class package");
        }
        Map<Long, List<LocalSpiProperties.LocalSpiConfig>> configMap = null;
        switch (levelType) {
            case GLOBAL: {
                configMap = Collections.singletonMap(0L, this.localSPIProperties.getGlobal());
                break;
            }
            case TENANT: {
                configMap = this.localSPIProperties.getTenant();
                break;
            }
            case ZONE: {
                configMap = this.localSPIProperties.getZone();
                break;
            }
            case INSTANCE: {
                configMap = this.localSPIProperties.getInstance();
                break;
            }
            default: {
                throw new IllegalArgumentException("IllegalArgument levelType:" + levelType);
            }
        }
        if (null != configMap && !CollectionUtils.isEmpty((Collection)configMap.get(levelId)) && null != (config = (LocalSpiProperties.LocalSpiConfig)configMap.get(levelId).stream().filter(c -> spiPointDefinition.getFunctionCode().equals(c.getFunctionCode()) && spiPointDefinition.getCode().equals(c.getCode())).findFirst().orElse(null))) {
            return config.getVal();
        }
        return this.getSpiCache(spiPointDefinition.getFunctionCode(), spiPointDefinition.getCode(), levelType, levelId);
    }

    private String getSpiCache(String functionCode, String configurationKey, LevelType levelType, long levelId) {
        String cacheKey = this.getCacheKey(functionCode, configurationKey, levelType, levelId);
        return CACHE.get(cacheKey);
    }

    private void putSpiCache(String functionCode, String configurationKey, String value, LevelType levelType, long levelId) {
        String cacheKey = this.getCacheKey(functionCode, configurationKey, levelType, levelId);
        CACHE.put(cacheKey, value);
    }

    private String getCacheKey(String functionCode, String code, LevelType levelType, long levelId) {
        return String.format("%s:%s:%s:%s", functionCode, code, levelType, levelId);
    }
}

