/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi;

import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.spi.ISpiHelper;
import com.cyberway.mp.bbc.spi.SpiContextUtil;
import com.cyberway.mp.bbc.spi.annotation.SPIPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SPILoader<T> {
    private static final ConcurrentHashMap<Class<?>, SPILoader<?>> SPI_LOADERS = new ConcurrentHashMap();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, T> instanceCache;
    private final Class<T> type;

    public SPILoader(Class<T> type) {
        this.type = type;
        this.instanceCache = new ConcurrentHashMap();
    }

    public static <T> SPILoader<T> getSPILoader(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("SPI type == null");
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("SPI type (" + type + ") is not an interface!");
        }
        if (!SPILoader.withSPIAnnotation(type)) {
            throw new IllegalArgumentException("SPIPoint type (" + type + ") is not an SPIPoint, because it is NOT annotated with @" + SPIPoint.class.getSimpleName() + "!");
        }
        SPILoader<?> loader = SPI_LOADERS.get(type);
        if (loader == null) {
            SPI_LOADERS.putIfAbsent(type, new SPILoader<T>(type));
            loader = SPI_LOADERS.get(type);
        }
        return loader;
    }

    private static <T> boolean withSPIAnnotation(Class<T> type) {
        SPIPoint spiPoint = type.getAnnotation(SPIPoint.class);
        return spiPoint != null;
    }

    public T getSPIImpl() {
        return this.getSPIImpl(LevelType.GLOBAL, 0L);
    }

    public T getTenantSPIImpl(long tenantId) {
        return this.getSPIImpl(LevelType.TENANT, tenantId);
    }

    public T getZoneSPIImpl(long zoneId) {
        return this.getSPIImpl(LevelType.ZONE, zoneId);
    }

    public T getInstanceSPIImpl(long instanceId) {
        return this.getSPIImpl(LevelType.INSTANCE, instanceId);
    }

    private T getSPIImpl(LevelType levelType, long levelId) {
        if (!this.isSingleInstance()) {
            throw new IllegalCallerException(this.type + "is not singleChoice,please use getSPIImpls() instead");
        }
        ISpiHelper helper = SpiContextUtil.getBean(ISpiHelper.class);
        String configVal = helper.getConfig(this.type, levelType, levelId);
        return this.getInstance(configVal, levelType, levelId);
    }

    public List<T> getSPIImpls() {
        return this.getSPIImpls(LevelType.GLOBAL, 0L);
    }

    public List<T> getTenantSPIImpls(long tenantId) {
        return this.getSPIImpls(LevelType.TENANT, tenantId);
    }

    public List<T> getZoneSPIImpls(long zoneId) {
        return this.getSPIImpls(LevelType.ZONE, zoneId);
    }

    public List<T> getInstanceSPIImpls(long instanceId) {
        return this.getSPIImpls(LevelType.INSTANCE, instanceId);
    }

    public List<T> getSPIImpls(LevelType levelType, long levelId) {
        if (this.isSingleInstance()) {
            throw new IllegalCallerException(this.type + "is singleChoice,please use getSPIImpl() instead");
        }
        ISpiHelper helper = SpiContextUtil.getBean(ISpiHelper.class);
        String configValArrayStr = helper.getConfig(this.type, levelType, levelId);
        return this.getInstanceList(configValArrayStr, levelType, levelId);
    }

    private T getInstance(String configVal, LevelType levelType, long levelId) {
        this.validateConfigVal(configVal, levelType, levelId);
        T instance = this.instanceCache.get(configVal);
        if (null == instance) {
            this.registerBean(configVal);
            instance = this.instanceCache.get(configVal);
        }
        return instance;
    }

    private List<T> getInstanceList(String configValArrayStr, LevelType levelType, long levelId) {
        this.validateConfigVal(configValArrayStr, levelType, levelId);
        String[] configValArr = configValArrayStr.split(",");
        ArrayList<T> instanceList = new ArrayList<T>(configValArr.length);
        for (String configVal : configValArr) {
            T instance = this.instanceCache.get(configVal);
            if (null == instance) {
                this.registerBean(configVal);
                instance = this.instanceCache.get(configVal);
            }
            instanceList.add(instance);
        }
        return instanceList;
    }

    private void validateConfigVal(String configVal, LevelType levelType, long levelId) {
        if (!StringUtils.hasLength((String)configVal)) {
            SPIPoint spiPoint = this.type.getAnnotation(SPIPoint.class);
            throw new IllegalStateException("Need to configure [" + spiPoint.name() + "] for " + levelType + ":" + levelId);
        }
    }

    private boolean isSingleInstance() {
        SPIPoint spiPoint = this.type.getAnnotation(SPIPoint.class);
        return spiPoint.singleChoice();
    }

    public void registerBean(String className) {
        Class<?> instanceClass;
        Assert.hasText((String)className, (String)"className must be not empty");
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)SpiContextUtil.getBeanFactory();
        try {
            instanceClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(className + "not found");
        }
        String beanName = this.getSPIImplBeanName(instanceClass);
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(instanceClass);
        defaultListableBeanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        Object instanceBean = defaultListableBeanFactory.getBean(beanName, this.type);
        this.instanceCache.putIfAbsent(className, instanceBean);
    }

    private String getSPIImplBeanName(Class<?> spiImplClass) {
        return "sPIImpl_" + spiImplClass.getSimpleName();
    }
}

