/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi;

import com.cyberway.mp.bbc.spi.EnableSPI;
import com.cyberway.mp.bbc.spi.annotation.SPIImpl;
import com.cyberway.mp.bbc.spi.annotation.SPIPoint;
import com.cyberway.mp.bbc.spi.bean.SpiImplDefinition;
import com.cyberway.mp.bbc.spi.bean.SpiPointDefinition;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpiScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableSPI.class.getName()));
        if (null == annotationAttrs) {
            return;
        }
        String[] basePackages = annotationAttrs.getStringArray("basePackages");
        LinkedHashSet candidateComponents = new LinkedHashSet();
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SPIPoint.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SPIImpl.class));
        for (String basePackage : basePackages) {
            candidateComponents.addAll(scanner.findCandidateComponents(basePackage));
        }
        for (BeanDefinition candidateComponent : candidateComponents) {
            if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
            AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
            if (annotationMetadata.hasAnnotation(SPIPoint.class.getCanonicalName())) {
                this.handleSpiPoint(ClassUtils.resolveClassName((String)annotationMetadata.getClassName(), null), registry);
                continue;
            }
            if (!annotationMetadata.hasAnnotation(SPIImpl.class.getCanonicalName())) continue;
            this.handleSpiImpl(ClassUtils.resolveClassName((String)annotationMetadata.getClassName(), null), registry);
        }
    }

    private void handleSpiImpl(Class<?> spiImplClass, BeanDefinitionRegistry registry) {
        Assert.isTrue((!spiImplClass.isInterface() && !Modifier.isAbstract(spiImplClass.getModifiers()) ? 1 : 0) != 0, (String)"@SPIImpl not allow specified on interface or abstract");
        String beanName = this.getSpiImplDefinitionBeanName(spiImplClass);
        if (!registry.containsBeanDefinition(beanName)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpiImplDefinition.class);
            Class<?>[] interfaces = spiImplClass.getInterfaces();
            if (interfaces.length != 1) {
                throw new IllegalArgumentException(spiImplClass + " must implement one interface");
            }
            Class<?> interfaceType = interfaces[0];
            if (null == interfaceType.getAnnotation(SPIPoint.class)) {
                throw new IllegalArgumentException(interfaceType + " must annotated with @SPIPoint");
            }
            beanDefinitionBuilder.addConstructorArgValue((Object)beanName);
            beanDefinitionBuilder.addConstructorArgValue(spiImplClass);
            beanDefinitionBuilder.addConstructorArgValue(interfaceType);
            beanDefinitionBuilder.addConstructorArgValue((Object)spiImplClass.getAnnotation(SPIImpl.class));
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
    }

    private void handleSpiPoint(Class<?> spiPointClass, BeanDefinitionRegistry registry) {
        Assert.isTrue((boolean)spiPointClass.isInterface(), (String)"@SPIPoint can only be specified on interface");
        String beanName = this.getSpiPointDefinitionBeanName(spiPointClass);
        if (!registry.containsBeanDefinition(beanName)) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpiPointDefinition.class);
            if (null == spiPointClass.getAnnotation(SPIPoint.class)) {
                throw new IllegalArgumentException(spiPointClass + " must annotated with @SPIPoint");
            }
            beanDefinitionBuilder.addConstructorArgValue((Object)beanName);
            beanDefinitionBuilder.addConstructorArgValue(spiPointClass);
            beanDefinitionBuilder.addConstructorArgValue((Object)spiPointClass.getAnnotation(SPIPoint.class));
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
    }

    private String getSpiImplDefinitionBeanName(Class<?> spiImplClass) {
        return "sPIImpl_def_" + spiImplClass.getSimpleName();
    }

    private String getSpiPointDefinitionBeanName(Class<?> spiPointClass) {
        return "sPIPoint_def_" + spiPointClass.getSimpleName();
    }

    private ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }
}

