/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi.config;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.spi.DefaultSpiHelper;
import com.cyberway.mp.bbc.spi.ISpiHelper;
import com.cyberway.mp.bbc.spi.LocalSpiHelper;
import com.cyberway.mp.bbc.spi.LocalSpiProperties;
import com.cyberway.mp.bbc.spi.bean.SpiImplDefinition;
import com.cyberway.mp.bbc.spi.bean.SpiPointDefinition;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="spi", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={LocalSpiProperties.class})
public class SpiConfiguration {
    @ConditionalOnProperty(prefix="spi", name={"mode"}, havingValue="default", matchIfMissing=true)
    @Bean(name={"spiHelper"})
    @ConditionalOnMissingBean
    public ISpiHelper defaultSpiHelper(List<SpiPointDefinition> spiPointDefinitions, List<SpiImplDefinition> spiImplDefinitions, ConfigurationApi configurationApi) {
        return new DefaultSpiHelper(spiPointDefinitions, spiImplDefinitions, configurationApi);
    }

    @ConditionalOnProperty(prefix="spi", name={"mode"}, havingValue="local", matchIfMissing=false)
    @Bean(name={"spiHelper"})
    @ConditionalOnMissingBean
    public ISpiHelper localSpiHelper(List<SpiPointDefinition> spiPointDefinitions, List<SpiImplDefinition> spiImplDefinitions, LocalSpiProperties localSpiProperties) {
        return new LocalSpiHelper(spiPointDefinitions, spiImplDefinitions, localSpiProperties);
    }
}

