/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.i18n.api;

import com.cyberway.mp.bbc.i18n.api.dto.req.SystemInfoI18nCreateReqDto;
import com.cyberway.mp.bbc.i18n.api.dto.req.SystemInfoI18nQueryReqDto;
import com.cyberway.mp.bbc.i18n.api.dto.resp.SystemInfoI18nRespDto;
import com.cyberway.mp.bc.common.api.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;

public interface ISystemInfoI18nApi {
    public void batchCreate(List<SystemInfoI18nCreateReqDto> var1);

    public Page<SystemInfoI18nRespDto> page(SystemInfoI18nQueryReqDto var1);

    public List<SystemInfoI18nRespDto> listByDomains(List<String> var1);

    public List<SystemInfoI18nRespDto> detail(String var1);

    public String getSystemInfoValue(String var1);

    default public void initSystemI18n2Local(StringRedisTemplate stringRedisTemplate, List<String> domains) {
        List<SystemInfoI18nRespDto> systemInfoI18nList = this.listByDomains(domains);
        if (!systemInfoI18nList.isEmpty()) {
            Map<String, List<SystemInfoI18nRespDto>> systemInfoI18nMap = systemInfoI18nList.stream().collect(Collectors.groupingBy(SystemInfoI18nRespDto::getCode));
            systemInfoI18nMap.forEach((key, list) -> {
                Map<String, String> langValueMap = list.stream().collect(Collectors.toMap(SystemInfoI18nRespDto::getLang, SystemInfoI18nRespDto::getValue));
                HashMap cacheMap = new HashMap(128);
                langValueMap.forEach((lang, value) -> cacheMap.put(key + lang, value));
                stringRedisTemplate.opsForHash().putAll((Object)"SystemInfoI18n:", cacheMap);
            });
        }
    }
}

