/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.i18n.api.exception;

import com.cyberway.mp.bbc.i18n.api.utils.SystemInfoI18nUtil;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;

public class BaseI18nException
extends BaseException {
    public BaseI18nException(Throwable cause) {
        super(cause);
    }

    public BaseI18nException(String code, String message) {
        super(code, BaseI18nException.getI18nMessage(code, message));
    }

    public BaseI18nException(String code, String message, Throwable cause) {
        super(code, BaseI18nException.getI18nMessage(code, message), cause);
    }

    public BaseI18nException(String code, String message, Throwable cause, Object ... errArgs) {
        super(code, BaseI18nException.getI18nMessage(code, message), cause, errArgs);
    }

    public BaseI18nException(ErrorCode errorCode) {
        super(errorCode.getCode(), BaseI18nException.getI18nMessage(errorCode.getCode(), errorCode.getMessage()));
    }

    public BaseI18nException(ErrorCode errorCode, Object ... errArgs) {
        this(errorCode.getCode(), errorCode.getMessage(), errArgs);
    }

    public BaseI18nException(ErrorCode errorCode, Throwable cause, Object ... errArgs) {
        super(errorCode.getCode(), BaseI18nException.getI18nMessage(errorCode.getCode(), errorCode.getMessage()), cause, errArgs);
    }

    public BaseI18nException(String code, String message, Object ... errArgs) {
        super(code, BaseI18nException.getI18nMessage(code, message), errArgs);
    }

    public static String getI18nMessage(String code, String message) {
        String i18nMessage = SystemInfoI18nUtil.getSystemInfoValue(code);
        message = i18nMessage == null ? message : i18nMessage;
        return message;
    }
}

