/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.aop;

import com.cyberway.mp.bc.auditlog.aop.DataSourceProxyHolder;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.DataSourceProxy;
import com.cyberway.mp.bc.auditlog.util.AuditLogContext;
import com.cyberway.mp.bc.common.utils.JUnitUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInfo;
import org.springframework.beans.BeanUtils;

public class AutoDataSourceProxyAdvice
implements MethodInterceptor,
IntroductionInfo {
    private final Class<? extends DataSourceProxy> dataSourceProxyClazz;

    public AutoDataSourceProxyAdvice(Class<? extends DataSourceProxy> dataSourceProxyClazz) {
        this.dataSourceProxyClazz = dataSourceProxyClazz;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!AuditLogContext.instance().isOpenAuditSwitch() || Boolean.TRUE.equals(JUnitUtils.isRunningTest())) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        Method m = BeanUtils.findDeclaredMethod(this.dataSourceProxyClazz, (String)method.getName(), (Class[])method.getParameterTypes());
        Class<?> declaringClass = method.getDeclaringClass();
        if (m != null && DataSource.class.isAssignableFrom(declaringClass)) {
            DataSourceProxy dataSourceProxy = DataSourceProxyHolder.get().putDataSource((DataSource)invocation.getThis());
            return m.invoke((Object)dataSourceProxy, args);
        }
        return invocation.proceed();
    }

    public Class<?>[] getInterfaces() {
        return new Class[]{Connection.class};
    }
}

