/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.aop;

import com.cyberway.mp.bc.auditlog.aop.AutoDataSourceProxyAdvice;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.DataSourceProxy;
import java.util.List;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.beans.BeansException;

public class AutoDataSourceProxyCreator
extends AbstractAutoProxyCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AutoDataSourceProxyCreator.class);
    private final List<String> excludes;
    private final Advisor advisor;

    public AutoDataSourceProxyCreator(boolean useJdkProxy, List<String> excludes) {
        this.excludes = excludes;
        this.advisor = new DefaultIntroductionAdvisor((Advice)new AutoDataSourceProxyAdvice(DataSourceProxy.class));
        this.setProxyTargetClass(!useJdkProxy);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Auto proxy of [{}]", (Object)beanName);
        }
        return new Object[]{this.advisor};
    }

    protected boolean shouldSkip(Class<?> beanClass, String beanName) {
        return !DataSource.class.isAssignableFrom(beanClass) || this.excludes.contains(beanClass.getName());
    }
}

