/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.aop;

import com.cyberway.mp.bc.auditlog.aop.DataSourceProxyHolder;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.DataSourceProxy;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DataSourceProxyBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceProxyBeanPostProcessor.class);
    private final List<String> excludes;

    public DataSourceProxyBeanPostProcessor(List<String> excludes) {
        this.excludes = excludes;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            if (!this.excludes.contains(bean.getClass().getName())) {
                DataSourceProxyHolder.get().putDataSource((DataSource)bean);
            }
            if (bean instanceof DataSourceProxy) {
                LOGGER.info("Unwrap the bean of the data source, and return the original data source to replace the data source proxy.");
                return ((DataSourceProxy)bean).getTargetDataSource();
            }
        }
        return bean;
    }
}

