/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.autoconfigure;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bc.auditlog.annotation.AuditLogColumn;
import com.cyberway.mp.bc.auditlog.annotation.AuditLogTable;
import com.cyberway.mp.bc.auditlog.autoconfigure.AuditConf;
import com.cyberway.mp.bc.auditlog.dto.AuditColumnMeta;
import com.cyberway.mp.bc.auditlog.dto.AuditTableMeta;
import com.cyberway.mp.bc.auditlog.util.AuditLogContext;
import io.seata.common.util.CollectionUtils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

@Configuration
@EnableConfigurationProperties(value={AuditConf.class})
public class ScanAuditColumnAutoConfiguration
implements ResourceLoaderAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ResourceLoader resourceLoader;
    private String logicDeleteClass = "com.cyberway.mp.bc.dal.annotation.LogicDelete";
    @Autowired
    private AuditConf auditConf;
    @Value(value="${spring.dal.colCaseType:0}")
    private int colCaseType;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @PostConstruct
    public void init() {
        if (CollectionUtils.isNotEmpty(this.auditConf.getPaths())) {
            ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
            CachingMetadataReaderFactory metaReader = new CachingMetadataReaderFactory(this.resourceLoader);
            ArrayList<AuditTableMeta> tables = new ArrayList<AuditTableMeta>();
            for (String path : this.auditConf.getPaths()) {
                path = path.replaceAll("\\.", "\\/");
                Resource[] resources = new Resource[]{};
                try {
                    for (Resource r : resources = resolver.getResources("classpath*:" + path + "/*.class")) {
                        MetadataReader metadataReader = metaReader.getMetadataReader(r);
                        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                        if (!annotationMetadata.hasAnnotation(AuditLogTable.class.getName())) continue;
                        ClassMetadata classMetadata = metadataReader.getClassMetadata();
                        Class<?> entityClass = Class.forName(classMetadata.getClassName());
                        List fieldsList = FieldUtils.getAllFieldsList(entityClass);
                        AuditLogTable auditLogTable = entityClass.getAnnotation(AuditLogTable.class);
                        List<AuditColumnMeta> auditColumnMetas = fieldsList.stream().map(field -> {
                            AuditLogColumn auditLogColumn = field.getAnnotation(AuditLogColumn.class);
                            AuditColumnMeta auditColumnMeta = null;
                            if (null != auditLogColumn) {
                                String name = auditLogColumn.name();
                                switch (this.colCaseType) {
                                    case 1: {
                                        name = name.toUpperCase();
                                        break;
                                    }
                                    case 2: {
                                        name = name.toLowerCase();
                                        break;
                                    }
                                }
                                auditColumnMeta = new AuditColumnMeta(name, auditLogColumn.comment(), auditLogColumn.enumClass());
                                auditColumnMeta.setGroupKey(auditLogColumn.groupKey());
                                auditColumnMeta.setBusinessId(auditLogColumn.businessId());
                                auditColumnMeta.setBusinessObject(auditLogColumn.businessObject());
                                auditColumnMeta.setIgnore(auditLogColumn.ignore());
                                auditColumnMeta.setDesc(auditLogColumn.isDesc());
                            }
                            return auditColumnMeta;
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                        if (annotationMetadata.hasAnnotation(this.logicDeleteClass)) {
                            AuditColumnMeta deleteColumnMeta = new AuditColumnMeta("deleted", "\u5220\u9664\u6807\u5fd7");
                            auditColumnMetas.add(deleteColumnMeta);
                        }
                        if (!CollectionUtils.isNotEmpty(auditColumnMetas)) continue;
                        String auditColumnMetaInfos = JSON.toJSONString(auditColumnMetas);
                        this.logger.info("\u626b\u63cf\u65e5\u5fd7\u7ec4\u4ef6\u5ba1\u8ba1\u8868, operateLogTable={}, auditColumnMetas={}", (Object)classMetadata.getClassName(), (Object)auditColumnMetaInfos);
                        AuditTableMeta auditTableMeta = new AuditTableMeta(auditLogTable.name(), auditLogTable.comment(), auditLogTable.merge());
                        auditTableMeta.setRelate(auditLogTable.relateFlag());
                        auditTableMeta.setColumns(auditColumnMetas);
                        tables.add(auditTableMeta);
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    this.logger.error("\u626b\u63cf\u65e5\u5fd7\u7ec4\u4ef6\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
                }
            }
            Map auditTableMetaMap = tables.stream().collect(Collectors.toMap(AuditTableMeta::getName, Function.identity()));
            AuditLogContext.AUDIT_TABLE_META_MAP.putAll(auditTableMetaMap);
        }
    }
}

