/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc;

import com.cyberway.mp.bc.auditlog.jdbc.executor.DeleteExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.Executor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.InsertExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.MultiExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.PlainExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.SelectForUpdateExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.SqlServerDeleteExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.SqlServerSelectForUpdateExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.SqlServerUpdateExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.executor.UpdateExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import com.cyberway.mp.bc.auditlog.sql.SQLVisitorFactory;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.sqlparser.SQLRecognizer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ExecuteTemplate {
    private ExecuteTemplate() {
        throw new IllegalStateException("Utility class");
    }

    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(List<SQLRecognizer> sqlRecognizers, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        Object rs;
        Executor executor;
        String dbType = statementProxy.getConnectionProxy().getDbType();
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            sqlRecognizers = "dm".equalsIgnoreCase(dbType) ? SQLVisitorFactory.get(statementProxy.getTargetSQL(), "oracle") : SQLVisitorFactory.get(statementProxy.getTargetSQL(), dbType);
        }
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else if (sqlRecognizers.size() == 1) {
            SQLRecognizer sqlRecognizer = sqlRecognizers.get(0);
            switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = (Executor)EnhancedServiceLoader.load(InsertExecutor.class, (String)dbType, (Class[])new Class[]{StatementProxy.class, StatementCallback.class, SQLRecognizer.class}, (Object[])new Object[]{statementProxy, statementCallback, sqlRecognizer});
                    break;
                }
                case UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new UpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerDeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new DeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    if ("sqlserver".equalsIgnoreCase(dbType)) {
                        executor = new SqlServerSelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                        break;
                    }
                    executor = new SelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                    break;
                }
            }
        } else {
            executor = new MultiExecutor<T, S>(statementProxy, statementCallback, sqlRecognizers);
        }
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex2) {
            SQLException ex2;
            if (!(ex2 instanceof SQLException)) {
                ex2 = new SQLException(ex2);
            }
            throw (SQLException)ex2;
        }
        return rs;
    }
}

