/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.executor;

import com.cyberway.mp.bc.auditlog.jdbc.executor.BaseTransactionalExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.ConnectionProxy;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractDMLBaseExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    protected static final String WHERE = " WHERE ";

    protected AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    protected AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    public T doExecute(Object ... args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        if (connectionProxy.getAutoCommit()) {
            return this.executeAutoCommitTrue(args);
        }
        return this.executeAutoCommitFalse(args);
    }

    protected T executeAutoCommitFalse(Object[] args) throws Exception {
        if (!"mysql".equalsIgnoreCase(this.getDbType()) && this.isMultiPk()) {
            throw new NotSupportYetException("multi pk only support mysql!");
        }
        TableRecords beforeImage = this.beforeImage();
        Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
        TableRecords afterImage = this.afterImage(beforeImage);
        this.prepareAuditRows(beforeImage, afterImage);
        return result;
    }

    private boolean isMultiPk() {
        if (null != this.sqlRecognizer) {
            return this.getTableMeta().getPrimaryKeyOnlyName().size() > 1;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.sqlRecognizers)) {
            List distinctSQLRecognizer = this.sqlRecognizers.stream().filter(AbstractDMLBaseExecutor.distinctByKey(t -> t.getTableName())).collect(Collectors.toList());
            for (SQLRecognizer sqlRecognizer : distinctSQLRecognizer) {
                if (this.getTableMeta(sqlRecognizer.getTableName()).getPrimaryKeyOnlyName().size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashMap map = new HashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    protected T executeAutoCommitTrue(Object[] args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        try {
            connectionProxy.changeAutoCommit();
            T result = this.executeAutoCommitFalse(args);
            connectionProxy.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            connectionProxy.getTargetConnection().rollback();
            throw e;
        }
        finally {
            connectionProxy.setAutoCommit(true);
        }
    }

    protected abstract TableRecords beforeImage() throws SQLException;

    protected abstract TableRecords afterImage(TableRecords var1) throws SQLException;
}

