/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.executor;

import com.cyberway.mp.bc.auditlog.dto.AuditColumn;
import com.cyberway.mp.bc.auditlog.dto.AuditColumnMeta;
import com.cyberway.mp.bc.auditlog.dto.AuditRow;
import com.cyberway.mp.bc.auditlog.dto.AuditTableMeta;
import com.cyberway.mp.bc.auditlog.jdbc.executor.Executor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.ConnectionProxy;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import com.cyberway.mp.bc.auditlog.util.AuditLogContext;
import com.cyberway.mp.bc.auditlog.util.ColumnUtils;
import com.cyberway.mp.bc.auditlog.util.ObjectUtils;
import com.cyberway.mp.bc.auditlog.util.SqlGenerateUtils;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.IOUtil;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMetaCacheFactory;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.ParametersHolder;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLType;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.struct.TableMeta;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransactionalExecutor<T, S extends Statement>
implements Executor<T> {
    private static boolean ONLY_CARE_UPDATE_COLUMNS;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected StatementProxy<S> statementProxy;
    protected StatementCallback<T, S> statementCallback;
    protected SQLRecognizer sqlRecognizer;
    protected List<SQLRecognizer> sqlRecognizers;
    private TableMeta tableMeta;

    protected BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizer = sqlRecognizer;
    }

    protected BaseTransactionalExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        this.statementProxy = statementProxy;
        this.statementCallback = statementCallback;
        this.sqlRecognizers = sqlRecognizers;
    }

    @Override
    public T execute(Object ... args) throws Throwable {
        return this.doExecute(args);
    }

    protected abstract T doExecute(Object ... var1) throws Throwable;

    protected String buildWhereCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String whereCondition = null;
        whereCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getWhereCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getWhereCondition();
        if (io.seata.common.util.StringUtils.isNotBlank((String)whereCondition) && CollectionUtils.isNotEmpty(paramAppenderList) && paramAppenderList.size() > 1) {
            StringBuilder whereConditionSb = new StringBuilder();
            whereConditionSb.append(" ( ").append(whereCondition).append(" ) ");
            for (int i = 1; i < paramAppenderList.size(); ++i) {
                whereConditionSb.append(" or ( ").append(whereCondition).append(" ) ");
            }
            whereCondition = whereConditionSb.toString();
        }
        return whereCondition;
    }

    protected String buildOrderCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String orderByCondition = null;
        orderByCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getOrderByCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getOrderByCondition();
        return orderByCondition;
    }

    protected String buildLimitCondition(WhereRecognizer recognizer, ArrayList<List<Object>> paramAppenderList) {
        String limitCondition = null;
        limitCondition = this.statementProxy instanceof ParametersHolder ? recognizer.getLimitCondition((ParametersHolder)this.statementProxy, paramAppenderList) : recognizer.getLimitCondition();
        return limitCondition;
    }

    protected String getColumnNameInSQL(String columnName) {
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "." + columnName;
    }

    protected String getColumnNamesInSQL(List<String> columnNameList) {
        if (Objects.isNull(columnNameList) || columnNameList.isEmpty()) {
            return null;
        }
        StringBuilder columnNamesStr = new StringBuilder();
        for (int i = 0; i < columnNameList.size(); ++i) {
            if (i > 0) {
                columnNamesStr.append(" , ");
            }
            columnNamesStr.append(this.getColumnNameInSQL(columnNameList.get(i)));
        }
        return columnNamesStr.toString();
    }

    protected String getFromTableInSQL() {
        String tableName = this.sqlRecognizer.getTableName();
        String tableAlias = this.sqlRecognizer.getTableAlias();
        return tableAlias == null ? tableName : tableName + " " + tableAlias;
    }

    protected TableMeta getTableMeta() {
        return this.getTableMeta(this.sqlRecognizer.getTableName());
    }

    protected TableMeta getTableMeta(String tableName) {
        if (this.tableMeta != null) {
            return this.tableMeta;
        }
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        this.tableMeta = TableMetaCacheFactory.getTableMetaCache((String)connectionProxy.getDbType()).getTableMeta(connectionProxy.getTargetConnection(), tableName, "DEFAULT");
        return this.tableMeta;
    }

    protected boolean containsPK(List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(columns, this.getDbType());
        return this.getTableMeta().containsPK(newColumns);
    }

    protected boolean containsPK(String tableName, List<String> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return false;
        }
        List<String> newColumns = ColumnUtils.delEscape(columns, this.getDbType());
        return this.getTableMeta(tableName).containsPK(newColumns);
    }

    protected boolean containPK(String columnName) {
        String newColumnName = ColumnUtils.delEscape(columnName, this.getDbType());
        return CollectionUtils.toUpperList((List)this.getTableMeta().getPrimaryKeyOnlyName()).contains(newColumnName.toUpperCase());
    }

    protected String getStandardPkColumnName(String userColumnName) {
        String newUserColumnName = ColumnUtils.delEscape(userColumnName, this.getDbType());
        for (String cn : this.getTableMeta().getPrimaryKeyOnlyName()) {
            if (!cn.equalsIgnoreCase(newUserColumnName)) continue;
            return cn;
        }
        return null;
    }

    protected void prepareAuditRows(TableRecords beforeImage, TableRecords afterImage) throws SQLException {
        if (beforeImage.getRows().isEmpty() && afterImage.getRows().isEmpty()) {
            return;
        }
        if (SQLType.UPDATE == this.sqlRecognizer.getSQLType() && beforeImage.getRows().size() != afterImage.getRows().size()) {
            throw new ShouldNeverHappenException("Before image size is not equaled to after image size, probably because you updated the primary keys.");
        }
        SQLType sqlType = this.sqlRecognizer.getSQLType();
        List<AuditRow> auditRows = null;
        if (SQLType.INSERT.equals((Object)sqlType)) {
            auditRows = this.parseInsertOrDeleteAuditRows(afterImage, sqlType);
        } else if (SQLType.DELETE.equals((Object)sqlType)) {
            auditRows = this.parseInsertOrDeleteAuditRows(beforeImage, sqlType);
        } else if (SQLType.UPDATE.equals((Object)sqlType)) {
            auditRows = this.parseUpdateAuditRows(beforeImage, afterImage);
        }
        AuditLogContext.instance().putAuditRows(afterImage.getTableName(), auditRows);
    }

    private List<AuditRow> parseUpdateAuditRows(TableRecords beforeImage, TableRecords afterImage) {
        TableMeta tableMetaImage = beforeImage.getTableMeta();
        AuditTableMeta auditTableMeta = AuditLogContext.AUDIT_TABLE_META_MAP.get(tableMetaImage.getTableName());
        if (auditTableMeta == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5ba1\u8ba1\u8868\u4fe1\u606f\uff0c\u76f4\u63a5\u5ffd\u7565, tableName={}", (Object)tableMetaImage.getTableName());
            return Collections.emptyList();
        }
        Map auditColumnMetaMap = auditTableMeta.getColumns().stream().collect(Collectors.toMap(AuditColumnMeta::getKeyName, Function.identity()));
        Map<String, Map<String, Field>> beforeRowMap = this.rows2Map(beforeImage.getRows());
        Map<String, Map<String, Field>> afterRowMap = this.rows2Map(afterImage.getRows());
        ArrayList<AuditRow> auditRows = new ArrayList<AuditRow>();
        beforeRowMap.forEach((id, beforeFieldMap) -> {
            Map afterFieldMap = (Map)afterRowMap.get(id);
            if (afterFieldMap == null) {
                return;
            }
            AuditRow auditRow = new AuditRow();
            auditRow.setId((String)id);
            auditRow.setTableName(auditTableMeta.getName());
            auditRow.setTableCommnet(auditTableMeta.getComment());
            auditRow.setSqlType(SQLType.UPDATE);
            List<AuditColumn> auditColumns = beforeFieldMap.values().stream().map(beforeField -> {
                String fieldName = beforeField.getName();
                AuditColumnMeta auditColumnMeta = (AuditColumnMeta)auditColumnMetaMap.get(fieldName);
                if (auditColumnMeta == null) {
                    return null;
                }
                AuditColumn auditColumn = new AuditColumn((String)id, auditColumnMeta.getKeyName(), auditColumnMeta.getKeyComment(), auditColumnMeta.isDesc());
                boolean isBusiness = auditColumnMeta.isBusinessId() || auditColumnMeta.isBusinessObject();
                Field afterField = (Field)afterFieldMap.get(fieldName);
                if (afterField == null && !isBusiness) {
                    return null;
                }
                auditColumn.setOldValue(ObjectUtils.object2String(beforeField.getValue(), auditColumnMeta.getEnumClass()));
                if (afterField != null) {
                    if (Objects.equals(afterField.getValue(), beforeField.getValue()) && !isBusiness && !auditColumnMeta.isDesc()) {
                        this.logger.debug("\u5ba1\u8ba1\u5b57\u6bb5\u7684\u503c\u6ca1\u6709\u4ea7\u751f\u53d8\u5316\uff0c\u76f4\u63a5\u5ffd\u7565, tableName={}, columnName={}", (Object)tableMetaImage.getTableName(), (Object)afterField.getName());
                        return null;
                    }
                    auditColumn.setNewValue(ObjectUtils.object2String(afterField.getValue(), auditColumnMeta.getEnumClass()));
                }
                return auditColumn;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            String groupKey = auditColumns.stream().map(auditColumn -> {
                AuditColumnMeta auditColumnMeta = (AuditColumnMeta)auditColumnMetaMap.get(auditColumn.getKeyName());
                return auditColumnMeta.isGroupKey() ? auditColumn.getNewValue() : null;
            }).filter(Objects::nonNull).sorted().collect(Collectors.joining());
            auditRow.setGroupKey(groupKey);
            auditRow.setColumns(auditColumns);
            auditRows.add(auditRow);
        });
        return auditRows;
    }

    private Map<String, Map<String, Field>> rows2Map(List<Row> rows) {
        HashMap<String, Map<String, Field>> beforeRowMap = new HashMap<String, Map<String, Field>>();
        for (Row row : rows) {
            List primaryKeyFields = row.primaryKeys().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
            List primaryKeyValues = primaryKeyFields.stream().map(Field::getValue).map(Object::toString).collect(Collectors.toList());
            String primaryKeyValueStr = StringUtils.join(primaryKeyValues, (String)"");
            beforeRowMap.put(primaryKeyValueStr, row.getFields().stream().collect(Collectors.toMap(Field::getName, Function.identity(), (a, b) -> a)));
        }
        return beforeRowMap;
    }

    private List<AuditRow> parseInsertOrDeleteAuditRows(TableRecords tableRecords, SQLType sqlType) {
        TableMeta tableMetaImage = tableRecords.getTableMeta();
        AuditTableMeta auditTableMeta = AuditLogContext.AUDIT_TABLE_META_MAP.get(tableMetaImage.getTableName());
        if (auditTableMeta == null) {
            this.logger.info("\u4e0d\u5b58\u5728\u5ba1\u8ba1\u8868\u4fe1\u606f\uff0c\u76f4\u63a5\u5ffd\u7565, tableName={}", (Object)tableMetaImage.getTableName());
            return Collections.emptyList();
        }
        List<AuditColumnMeta> auditColumnMetas = auditTableMeta.getColumns();
        if (CollectionUtils.isEmpty(auditColumnMetas)) {
            this.logger.info("\u4e0d\u5b58\u5728\u5ba1\u8ba1\u6807\u8bb0\u5b57\u6bb5\uff0c\u76f4\u63a5\u5ffd\u7565, tableName={}", (Object)tableMetaImage.getTableName());
            return Collections.emptyList();
        }
        Map auditColumnMetaMap = auditColumnMetas.stream().collect(Collectors.toMap(AuditColumnMeta::getKeyName, Function.identity()));
        return tableRecords.getRows().stream().map(row -> {
            List primaryKeyFields = row.primaryKeys().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
            List primaryKeyValues = primaryKeyFields.stream().map(Field::getValue).map(Object::toString).collect(Collectors.toList());
            String id = StringUtils.join(primaryKeyValues, (String)"");
            AuditRow auditRow = new AuditRow();
            auditRow.setId(id);
            auditRow.setTableName(auditTableMeta.getName());
            auditRow.setTableCommnet(auditTableMeta.getComment());
            auditRow.setSqlType(sqlType);
            ArrayList groupKeys = new ArrayList();
            List<AuditColumn> auditColumns = row.getFields().stream().map(field -> {
                AuditColumnMeta auditColumnMeta = (AuditColumnMeta)auditColumnMetaMap.get(field.getName());
                if (null == auditColumnMeta) {
                    return null;
                }
                AuditColumn auditColumn = new AuditColumn(id, auditColumnMeta.getKeyName(), auditColumnMeta.getKeyComment(), auditColumnMeta.isDesc());
                if (SQLType.DELETE.equals((Object)sqlType)) {
                    auditColumn.setOldValue(ObjectUtils.object2String(field.getValue(), auditColumnMeta.getEnumClass()));
                } else if (SQLType.INSERT.equals((Object)sqlType)) {
                    auditColumn.setNewValue(ObjectUtils.object2String(field.getValue(), auditColumnMeta.getEnumClass()));
                }
                if (auditColumnMeta.isGroupKey()) {
                    groupKeys.add(SQLType.DELETE.equals((Object)sqlType) ? auditColumn.getOldValue() : auditColumn.getNewValue());
                }
                return auditColumn;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            String groupKey = groupKeys.stream().sorted().collect(Collectors.joining());
            auditRow.setGroupKey(groupKey);
            auditRow.setColumns(auditColumns);
            return auditRow;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(TableMeta tableMeta, String selectSQL, ArrayList<List<Object>> paramAppenderList) throws SQLException {
        TableRecords tableRecords;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(selectSQL);
            if (CollectionUtils.isNotEmpty(paramAppenderList)) {
                int ts = paramAppenderList.size();
                for (int i = 0; i < ts; ++i) {
                    List<Object> paramAppender = paramAppenderList.get(i);
                    int ds = paramAppender.size();
                    for (int j = 0; j < ds; ++j) {
                        ps.setObject(i * ds + j + 1, paramAppender.get(j));
                    }
                }
            }
            rs = ps.executeQuery();
            tableRecords = TableRecords.buildRecords((TableMeta)tableMeta, (ResultSet)rs);
        }
        catch (Throwable throwable) {
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            throw throwable;
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        return tableRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords buildTableRecords(Map<String, List<Object>> pkValuesMap) throws SQLException {
        TableRecords tableRecords;
        List pkColumnNameList = this.getTableMeta().getPrimaryKeyOnlyName();
        StringBuilder sql = new StringBuilder().append("SELECT * FROM ").append(this.getFromTableInSQL()).append(" WHERE ");
        String firstKey = pkValuesMap.keySet().stream().findFirst().orElse(null);
        int rowSize = pkValuesMap.get(firstKey).size();
        sql.append(SqlGenerateUtils.buildWhereConditionByPKs(pkColumnNameList, rowSize, this.getDbType()));
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.statementProxy.getConnection().prepareStatement(sql.toString());
            int paramIndex = 1;
            for (int r = 0; r < rowSize; ++r) {
                for (int c = 0; c < pkColumnNameList.size(); ++c) {
                    List<Object> pkColumnValueList = pkValuesMap.get(pkColumnNameList.get(c));
                    int dataType = this.tableMeta.getColumnMeta((String)pkColumnNameList.get(c)).getDataType();
                    ps.setObject(paramIndex, pkColumnValueList.get(r), dataType);
                    ++paramIndex;
                }
            }
            rs = ps.executeQuery();
            tableRecords = TableRecords.buildRecords((TableMeta)this.getTableMeta(), (ResultSet)rs);
        }
        catch (Throwable throwable) {
            IOUtil.close(rs);
            throw throwable;
        }
        IOUtil.close((AutoCloseable)rs);
        return tableRecords;
    }

    protected List<String> getNeedColumns(String table, String tableAlias, List<String> unescapeColumns) {
        TreeSet<String> needUpdateColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        TableMeta tableMeta = this.getTableMeta(table);
        if (ONLY_CARE_UPDATE_COLUMNS && CollectionUtils.isNotEmpty(unescapeColumns)) {
            List pkNameList;
            if (!this.containsPK(table, unescapeColumns) && CollectionUtils.isNotEmpty((Collection)(pkNameList = tableMeta.getEscapePkNameList(this.getDbType())))) {
                if (io.seata.common.util.StringUtils.isNotBlank((String)tableAlias)) {
                    needUpdateColumns.addAll(ColumnUtils.delEscape(this.getColumnNamesWithTablePrefixList(table, tableAlias, pkNameList), this.getDbType()));
                } else {
                    needUpdateColumns.addAll(ColumnUtils.delEscape(this.getColumnNamesInSQLList(pkNameList), this.getDbType()));
                }
            }
            needUpdateColumns.addAll(unescapeColumns);
            List onUpdateColumns = tableMeta.getOnUpdateColumnsOnlyName();
            if (io.seata.common.util.StringUtils.isNotBlank((String)tableAlias)) {
                onUpdateColumns = onUpdateColumns.stream().map(onUpdateColumn -> this.getColumnNameWithTablePrefix(table, tableAlias, (String)onUpdateColumn)).collect(Collectors.toList());
            }
            needUpdateColumns.addAll(onUpdateColumns);
        } else {
            Stream<Object> allColumns = tableMeta.getAllColumns().keySet().stream();
            if (io.seata.common.util.StringUtils.isNotBlank((String)tableAlias)) {
                allColumns = allColumns.map(columnName -> this.getColumnNameWithTablePrefix(table, tableAlias, (String)columnName));
            }
            allColumns.forEach(needUpdateColumns::add);
        }
        return needUpdateColumns.stream().map(column -> ColumnUtils.addEscape(column, this.getDbType(), tableMeta)).collect(Collectors.toList());
    }

    protected List<String> getColumnNamesInSQLList(List<String> columnNames) {
        ArrayList<String> columnNameWithTableAlias = new ArrayList<String>();
        for (String columnName : columnNames) {
            columnNameWithTableAlias.add(this.getColumnNameInSQL(columnName));
        }
        return columnNameWithTableAlias;
    }

    protected List<String> getColumnNamesWithTablePrefixList(String table, String tableAlias, List<String> columnNames) {
        ArrayList<String> columnNameWithTablePrefix = new ArrayList<String>();
        for (String columnName : columnNames) {
            columnNameWithTablePrefix.add(this.getColumnNameWithTablePrefix(table, tableAlias, columnName));
        }
        return columnNameWithTablePrefix;
    }

    protected String getColumnNameWithTablePrefix(String table, String tableAlias, String columnName) {
        return tableAlias == null ? (table == null ? columnName : table + "." + columnName) : tableAlias + "." + columnName;
    }

    protected String getDbType() {
        return this.statementProxy.getConnectionProxy().getDbType();
    }

    static {
        try {
            Configuration configuration = ConfigurationFactory.getInstance();
            ONLY_CARE_UPDATE_COLUMNS = configuration.getBoolean("client.undo.onlyCareUpdateColumns", true);
        }
        catch (Exception ex) {
            ONLY_CARE_UPDATE_COLUMNS = true;
        }
    }
}

