/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.executor;

import com.cyberway.mp.bc.auditlog.jdbc.executor.AbstractDMLBaseExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.executor.UpdateExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import com.cyberway.mp.bc.auditlog.util.SqlGenerateUtils;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.struct.TableMeta;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

public class MultiUpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = true;

    public MultiUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        if (this.sqlRecognizers.size() == 1) {
            UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
            return executor.beforeImage();
        }
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        HashSet updateColumnsSet = new HashSet();
        StringBuilder whereCondition = new StringBuilder();
        boolean noWhereCondition = false;
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)recognizer;
            if (StringUtils.isNotBlank((String)sqlUpdateRecognizer.getLimitCondition())) {
                throw new NotSupportYetException("Multi update SQL with limit condition is not support yet !");
            }
            if (StringUtils.isNotBlank((String)sqlUpdateRecognizer.getOrderByCondition())) {
                throw new NotSupportYetException("Multi update SQL with orderBy condition is not support yet !");
            }
            List updateColumns = sqlUpdateRecognizer.getUpdateColumnsUnEscape();
            updateColumnsSet.addAll(updateColumns);
            if (noWhereCondition) continue;
            String whereConditionStr = this.buildWhereCondition((WhereRecognizer)sqlUpdateRecognizer, paramAppenderList);
            if (StringUtils.isBlank((String)whereConditionStr)) {
                noWhereCondition = true;
                continue;
            }
            if (whereCondition.length() > 0) {
                whereCondition.append(" OR ");
            }
            whereCondition.append(whereConditionStr);
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        if (noWhereCondition) {
            paramAppenderList.clear();
            whereCondition = new StringBuilder();
        }
        StringJoiner selectSQLAppender = new StringJoiner(", ", prefix, this.buildSuffixSql(whereCondition.toString()));
        List<String> needColumns = this.getNeedColumns(tmeta.getTableName(), this.sqlRecognizer.getTableAlias(), new ArrayList<String>(updateColumnsSet));
        needColumns.forEach(selectSQLAppender::add);
        return this.buildTableRecords(tmeta, selectSQLAppender.toString(), paramAppenderList);
    }

    /*
     * Loose catch block
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableRecords tableRecords;
        PreparedStatement pst;
        ResultSet rs;
        block10: {
            if (this.sqlRecognizers.size() == 1) {
                UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
                return executor.afterImage(beforeImage);
            }
            if (beforeImage == null || beforeImage.size() == 0) {
                return TableRecords.empty((TableMeta)this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName()));
            }
            TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
            String selectSQL = this.buildAfterImageSQL(tmeta, beforeImage);
            rs = null;
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            SqlGenerateUtils.setParamForPk(beforeImage.pkRows(), this.getTableMeta().getPrimaryKeyOnlyName(), pst);
            rs = pst.executeQuery();
            tableRecords = TableRecords.buildRecords((TableMeta)tmeta, (ResultSet)rs);
            if (pst == null) break block10;
            pst.close();
        }
        IOUtil.close((AutoCloseable)rs);
        return tableRecords;
        {
            catch (Throwable throwable) {
                try {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    IOUtil.close(rs);
                    throw throwable3;
                }
            }
        }
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) {
        HashSet updateColumnsSet = new HashSet();
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
            updateColumnsSet.addAll(sqlUpdateRecognizer.getUpdateColumnsUnEscape());
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        String suffix = " FROM " + this.getFromTableInSQL() + " WHERE " + SqlGenerateUtils.buildWhereConditionByPKs(tableMeta.getPrimaryKeyOnlyName(), beforeImage.pkRows().size(), this.getDbType());
        StringJoiner selectSQLJoiner = new StringJoiner(", ", prefix.toString(), suffix);
        if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
            selectSQLJoiner.add(this.getColumnNamesInSQL(tableMeta.getEscapePkNameList(this.getDbType())));
        }
        for (String updateCol : updateColumnsSet) {
            selectSQLJoiner.add(updateCol);
        }
        return selectSQLJoiner.toString();
    }

    protected String buildSuffixSql(String whereCondition) {
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        if (StringUtils.isNotBlank((String)whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        return suffix.append(" FOR UPDATE").toString();
    }
}

