/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.executor;

import com.cyberway.mp.bc.auditlog.jdbc.executor.BaseTransactionalExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLSelectRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectForUpdateExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForUpdateExecutor.class);

    public SelectForUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T doExecute(Object ... args) throws Throwable {
        Object rs;
        Connection conn = this.statementProxy.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        Savepoint sp = null;
        boolean originalAutoCommit = conn.getAutoCommit();
        try {
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            } else if (dbmd.supportsSavepoints()) {
                sp = conn.setSavepoint();
            } else {
                throw new SQLException("not support savepoint. please check your db version");
            }
            ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
            String selectPKSQL = this.buildSelectSQL(paramAppenderList);
            while (true) {
                try {
                    rs = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
                    TableRecords selectPKRows = this.buildTableRecords(this.getTableMeta(), selectPKSQL, paramAppenderList);
                }
                catch (Exception e) {
                    if (sp != null) {
                        conn.rollback(sp);
                        continue;
                    }
                    conn.rollback();
                    continue;
                }
                break;
            }
        }
        finally {
            if (sp != null) {
                try {
                    if (!"oracle".equalsIgnoreCase(this.getDbType())) {
                        conn.releaseSavepoint(sp);
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("{} release save point error.", (Object)this.getDbType(), (Object)e);
                }
            }
            if (originalAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        return rs;
    }

    protected String buildSelectSQL(ArrayList<List<Object>> paramAppenderList) {
        SQLSelectRecognizer recognizer = (SQLSelectRecognizer)this.sqlRecognizer;
        StringBuilder selectSQLAppender = new StringBuilder("SELECT ");
        selectSQLAppender.append(this.getColumnNamesInSQL(this.getTableMeta().getEscapePkNameList(this.getDbType())));
        selectSQLAppender.append(" FROM ").append(this.getFromTableInSQL());
        String whereCondition = this.buildWhereCondition((WhereRecognizer)recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            selectSQLAppender.append(" WHERE ").append(whereCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        return selectSQLAppender.toString();
    }
}

