/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.executor;

import com.cyberway.mp.bc.auditlog.dto.AuditColumnMeta;
import com.cyberway.mp.bc.auditlog.dto.AuditTableMeta;
import com.cyberway.mp.bc.auditlog.jdbc.executor.AbstractDMLBaseExecutor;
import com.cyberway.mp.bc.auditlog.jdbc.executor.StatementCallback;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.StatementProxy;
import com.cyberway.mp.bc.auditlog.util.AuditLogContext;
import com.cyberway.mp.bc.auditlog.util.ColumnUtils;
import com.cyberway.mp.bc.auditlog.util.SqlGenerateUtils;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.struct.TableMeta;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateExecutor.class);
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = true;

    public UpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        TableMeta tmeta = this.getTableMeta();
        String selectSQL = this.buildBeforeImageSQL(tmeta, paramAppenderList);
        LOGGER.info("\u83b7\u53d6\u5ba1\u8ba1\u7684\u524d\u955c\u50cf\u503c, selectSQL={}", (Object)selectSQL);
        return this.buildTableRecords(tmeta, selectSQL, paramAppenderList);
    }

    protected String buildBeforeImageSQL(TableMeta tableMeta, ArrayList<List<Object>> paramAppenderList) {
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        StringBuilder prefix = new StringBuilder("SELECT ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        String whereCondition = this.buildWhereCondition((WhereRecognizer)recognizer, paramAppenderList);
        String orderByCondition = this.buildOrderCondition((WhereRecognizer)recognizer, paramAppenderList);
        String limitCondition = this.buildLimitCondition((WhereRecognizer)recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            suffix.append(" WHERE ").append(whereCondition);
        }
        if (StringUtils.isNotBlank((String)orderByCondition)) {
            suffix.append(" ").append(orderByCondition);
        }
        if (StringUtils.isNotBlank((String)limitCondition)) {
            suffix.append(" ").append(limitCondition);
        }
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLJoin = new StringJoiner(", ", prefix.toString(), suffix.toString());
        List<String> needUpdateColumns = this.getNeedColumns(tableMeta.getTableName(), this.sqlRecognizer.getTableAlias(), recognizer.getUpdateColumnsUnEscape());
        needUpdateColumns.forEach(selectSQLJoin::add);
        return selectSQLJoin.toString();
    }

    /*
     * Loose catch block
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableRecords tableRecords;
        PreparedStatement pst;
        ResultSet rs;
        block9: {
            TableMeta tmeta = this.getTableMeta();
            if (beforeImage == null || beforeImage.size() == 0) {
                return TableRecords.empty((TableMeta)this.getTableMeta());
            }
            String selectSQL = this.buildAfterImageSQL(tmeta, beforeImage);
            rs = null;
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            SqlGenerateUtils.setParamForPk(beforeImage.pkRows(), this.getTableMeta().getPrimaryKeyOnlyName(), pst);
            rs = pst.executeQuery();
            tableRecords = TableRecords.buildRecords((TableMeta)tmeta, (ResultSet)rs);
            if (pst == null) break block9;
            pst.close();
        }
        IOUtil.close((AutoCloseable)rs);
        return tableRecords;
        {
            catch (Throwable throwable) {
                try {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    IOUtil.close(rs);
                    throw throwable3;
                }
            }
        }
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) {
        StringBuilder prefix = new StringBuilder("SELECT ");
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(tableMeta.getPrimaryKeyOnlyName(), beforeImage.pkRows().size(), this.getDbType());
        String suffix = " FROM " + this.getFromTableInSQL() + " WHERE " + whereSql;
        StringJoiner selectSQLJoiner = new StringJoiner(", ", prefix.toString(), suffix);
        SQLUpdateRecognizer recognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
        List<String> updateColumns = this.getUpdateColumns(recognizer);
        if (!this.containsPK(tableMeta.getTableName(), updateColumns)) {
            selectSQLJoiner.add(this.getColumnNamesInSQL(tableMeta.getEscapePkNameList(this.getDbType())));
        }
        for (String columnName : updateColumns) {
            selectSQLJoiner.add(columnName);
        }
        return selectSQLJoiner.toString();
    }

    private List<String> getUpdateColumns(SQLUpdateRecognizer recognizer) {
        String dbType = this.getDbType();
        Map<String, String> colMap = recognizer.getUpdateColumns().stream().collect(Collectors.toMap(item -> ColumnUtils.delEscape(item, dbType), item -> item, (a, b) -> b));
        AuditTableMeta auditTableMeta = AuditLogContext.AUDIT_TABLE_META_MAP.get(recognizer.getTableName());
        if (auditTableMeta != null && auditTableMeta.hasDescDetail()) {
            for (AuditColumnMeta descColumn : auditTableMeta.getDescColumns()) {
                String delEscapeCol = ColumnUtils.delEscape(descColumn.getKeyName(), dbType);
                if (colMap.containsKey(delEscapeCol)) continue;
                colMap.put(descColumn.getKeyName(), ColumnUtils.addEscape(delEscapeCol, dbType));
            }
        }
        return new ArrayList<String>(colMap.values());
    }
}

