/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.proxy;

import com.cyberway.mp.bc.auditlog.jdbc.proxy.AbstractConnectionProxy;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.DataSourceProxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class ConnectionProxy
extends AbstractConnectionProxy {
    public ConnectionProxy(DataSourceProxy dataSourceProxy, Connection targetConnection) {
        super(dataSourceProxy, targetConnection);
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.doCommit();
        }
        catch (SQLException e) {
            this.rollback();
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.targetConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.targetConnection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.targetConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.targetConnection.releaseSavepoint(savepoint);
    }

    private void doCommit() throws SQLException {
        this.targetConnection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.targetConnection.rollback();
    }

    public void changeAutoCommit() throws SQLException {
        this.setAutoCommit(false);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.targetConnection.setAutoCommit(autoCommit);
    }
}

