/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.jdbc.proxy;

import com.cyberway.mp.bc.auditlog.jdbc.proxy.AbstractDataSourceProxy;
import com.cyberway.mp.bc.auditlog.jdbc.proxy.ConnectionProxy;
import com.cyberway.mp.bc.auditlog.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceProxy
extends AbstractDataSourceProxy {
    private String jdbcUrl;
    private String dbType;
    private String userName;

    public DataSourceProxy(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
        this.init(targetDataSource);
    }

    private void init(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            this.dbType = JdbcUtils.getDbType(this.jdbcUrl);
            if ("oracle".equals(this.dbType)) {
                this.userName = connection.getMetaData().getUserName();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.dbType;
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, targetConnection);
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection);
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }
}

