/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.util;

import com.cyberway.mp.bc.auditlog.dto.AuditColumn;
import com.cyberway.mp.bc.auditlog.dto.AuditRow;
import com.cyberway.mp.bc.auditlog.dto.AuditTableMeta;
import com.google.common.collect.Lists;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AuditLogContext {
    public static final ThreadLocal<Map<String, List<AuditRow>>> TABLE_MAP_THREAD_LOCAL = ThreadLocal.withInitial(HashMap::new);
    public static final ThreadLocal<Map<String, Object>> GLOBAL_MAP_THREAD_LOCAL = ThreadLocal.withInitial(HashMap::new);
    public static final ThreadLocal<Boolean> AUDIT_SWITCH_THREAD_LOCAL = ThreadLocal.withInitial(() -> false);
    public static final Map<String, AuditTableMeta> AUDIT_TABLE_META_MAP = new HashMap<String, AuditTableMeta>();
    public static final ThreadLocal<Set<Long>> OPERATE_IDS_THREAD_LOCAL = ThreadLocal.withInitial(HashSet::new);

    public static AuditLogContext instance() {
        return new AuditLogContext();
    }

    public static void putGlobalVar(String key, Object val) {
        Map<String, Object> putMap = GLOBAL_MAP_THREAD_LOCAL.get();
        putMap.put(key, val);
    }

    public void putAuditRows(String tableName, List<AuditRow> newAuditRows) {
        if (CollectionUtils.isEmpty(newAuditRows)) {
            return;
        }
        newAuditRows.forEach(newAuditRow -> {
            Map<String, List<AuditRow>> oldAuditTableMap = TABLE_MAP_THREAD_LOCAL.get();
            if (CollectionUtils.isEmpty(oldAuditTableMap)) {
                oldAuditTableMap.put(tableName, Lists.newArrayList((Object[])new AuditRow[]{newAuditRow}));
            } else {
                List<AuditRow> auditRows = oldAuditTableMap.get(tableName);
                if (auditRows == null) {
                    auditRows = new ArrayList<AuditRow>();
                    auditRows.add((AuditRow)newAuditRow);
                    oldAuditTableMap.put(newAuditRow.getTableCommnet(), auditRows);
                } else {
                    AuditTableMeta auditTableMeta = AUDIT_TABLE_META_MAP.get(tableName);
                    if (!auditTableMeta.isMerge()) {
                        auditRows.add((AuditRow)newAuditRow);
                    } else {
                        Map auditRowMap = auditRows.stream().collect(Collectors.toMap(AuditRow::getId, Function.identity()));
                        AuditRow oldAuditRow = (AuditRow)auditRowMap.get(newAuditRow.getId());
                        if (oldAuditRow != null) {
                            List<AuditColumn> oldColumns = oldAuditRow.getColumns();
                            List<AuditColumn> newColumns = newAuditRow.getColumns();
                            Map oldColumnMap = oldColumns.stream().collect(Collectors.toMap(AuditColumn::getKeyName, Function.identity()));
                            List updateColumns = newColumns.stream().map(newColumn -> {
                                AuditColumn oldColumn = (AuditColumn)oldColumnMap.get(newColumn.getKeyName());
                                if (null == oldColumn) {
                                    return newColumn;
                                }
                                oldColumn.setNewValue(newColumn.getNewValue());
                                return oldColumn;
                            }).collect(Collectors.toList());
                            oldColumns.retainAll(updateColumns);
                            oldAuditRow.setColumns(oldColumns);
                        } else {
                            auditRows.add((AuditRow)newAuditRow);
                        }
                    }
                }
            }
        });
    }

    public Map<String, List<AuditRow>> getAuditTableMap() {
        return TABLE_MAP_THREAD_LOCAL.get();
    }

    public void putOperateIds(List<Long> operateIds) {
        OPERATE_IDS_THREAD_LOCAL.get().addAll(operateIds);
    }

    public Set<Long> getOperateIds() {
        return OPERATE_IDS_THREAD_LOCAL.get();
    }

    public void openAuditSwitch() {
        AUDIT_SWITCH_THREAD_LOCAL.set(true);
    }

    public boolean isOpenAuditSwitch() {
        return AUDIT_SWITCH_THREAD_LOCAL.get();
    }

    public void clear() {
        TABLE_MAP_THREAD_LOCAL.get().clear();
        GLOBAL_MAP_THREAD_LOCAL.get().clear();
        AUDIT_SWITCH_THREAD_LOCAL.set(false);
    }
}

