/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.util;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.sqlparser.EscapeHandler;
import io.seata.sqlparser.EscapeHandlerFactory;
import io.seata.sqlparser.struct.TableMeta;
import java.util.ArrayList;
import java.util.List;

public final class ColumnUtils {
    private static final String ORACLE_DB_TYP = "oracle";

    private ColumnUtils() {
    }

    public static List<String> delEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.delEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String delEscape(String colName, String dbType) {
        if (dbType.equalsIgnoreCase(ORACLE_DB_TYP)) {
            colName = colName.toUpperCase();
        }
        EscapeHandler escapeHandler = EscapeHandlerFactory.getEscapeHandler((String)dbType);
        return escapeHandler.delColNameEscape(colName);
    }

    public static String addEscape(String colName, String dbType, TableMeta tableMeta) {
        if (StringUtils.isBlank((String)colName)) {
            return colName;
        }
        if (dbType.equalsIgnoreCase(ORACLE_DB_TYP)) {
            colName = colName.toUpperCase();
        }
        EscapeHandler escapeHandler = EscapeHandlerFactory.getEscapeHandler((String)dbType);
        return escapeHandler.addColNameEscape(colName, tableMeta);
    }

    public static List<String> addEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.addEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String addEscape(String colName, String dbType) {
        return ColumnUtils.addEscape(colName, dbType, null);
    }
}

