/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.auditlog.util;

import com.cyberway.mp.bc.auditlog.constant.BaseEnum;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;

public class ObjectUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectUtils.class);

    private ObjectUtils() {
        throw new UnsupportedOperationException();
    }

    public static String object2String(Object value, Class enumClass) {
        if (value == null) {
            return null;
        }
        String valueStr = null;
        if (value instanceof String) {
            valueStr = value.toString();
        } else if (value instanceof Byte) {
            valueStr = String.valueOf(((Byte)value).byteValue());
        } else if (value instanceof Integer) {
            valueStr = String.valueOf((Integer)value);
        } else if (value instanceof Long) {
            valueStr = String.valueOf((Long)value);
        } else if (value instanceof Double) {
            valueStr = String.valueOf((Double)value);
        } else if (value instanceof BigDecimal) {
            valueStr = ((BigDecimal)value).toString();
        } else if (value instanceof Boolean) {
            valueStr = String.valueOf((Boolean)value);
        } else if (value instanceof Date) {
            valueStr = DateFormatUtils.format((Date)((Date)value), (String)"yyyy-mm-dd HH:mm:ss");
        } else if (value instanceof LocalDateTime) {
            valueStr = ((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
        return ObjectUtils.getEnumDescribe(valueStr, enumClass);
    }

    public static String getEnumDescribe(String key, Class enumClass) {
        if (null != enumClass && BaseEnum.class.isAssignableFrom(enumClass)) {
            String describe = null;
            try {
                Class<?> aClass;
                ?[] enumConstants;
                Optional<Object> select;
                Class[] classes = GenericTypeResolver.resolveTypeArguments((Class)enumClass, BaseEnum.class);
                Class type = null;
                if (null != classes) {
                    type = classes[0];
                }
                if ((select = Arrays.stream(enumConstants = (aClass = Class.forName(enumClass.getName())).getEnumConstants()).filter(item -> item.toString().equalsIgnoreCase(key)).findFirst()).isPresent()) {
                    BaseEnum baseEnum = (BaseEnum)select.get();
                    if (String.class.isAssignableFrom(type)) {
                        describe = baseEnum.getDescribe(key);
                    } else if (Byte.class.isAssignableFrom(type)) {
                        describe = baseEnum.getDescribe(Byte.valueOf(key));
                    } else if (Integer.class.isAssignableFrom(type)) {
                        describe = baseEnum.getDescribe(Integer.valueOf(key));
                    } else if (Long.class.isAssignableFrom(type)) {
                        describe = baseEnum.getDescribe(Long.valueOf(key));
                    }
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("getEnumDescribe error", (Throwable)e);
            }
            return describe == null ? key : describe;
        }
        return key;
    }
}

