/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache;

import com.cyberway.mp.bc.cache.annotation.PosType;
import com.cyberway.mp.bc.cache.caffeine.CaffeineMultiCacheManager;
import com.cyberway.mp.bc.cache.config.MultiLevelCacheProperties;
import com.cyberway.mp.bc.cache.redis.RedisMultiCache;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.cache.RedisMultiCacheManager;

public class CacheFactory
implements ApplicationContextAware {
    @Autowired
    private MultiLevelCacheProperties multiLevelCacheProperties;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Cache findCache(PosType posType, int ttl, String cacheName) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        if (!configPosType.support(posType)) {
            throw new IllegalArgumentException("\u5168\u5c40\u914d\u7f6e\u4e0d\u652f\u6301\u8be5\u914d\u7f6e!");
        }
        if (posType.equals((Object)PosType.LOCAL) || posType.equals((Object)PosType.ALL)) {
            CaffeineMultiCacheManager caffeineMultiCacheManager = (CaffeineMultiCacheManager)((Object)this.applicationContext.getBean(CaffeineMultiCacheManager.class));
            if (ttl != -1) {
                caffeineMultiCacheManager.setTTl(cacheName, ttl);
            }
            return caffeineMultiCacheManager.getCache(cacheName);
        }
        if (posType.equals((Object)PosType.REMOTE)) {
            RedisMultiCacheManager redisMultiCacheManager = (RedisMultiCacheManager)((Object)this.applicationContext.getBean(RedisMultiCacheManager.class));
            RedisMultiCache redisMultiCache = (RedisMultiCache)redisMultiCacheManager.getCache(cacheName);
            if (null != redisMultiCache && ttl != -1) {
                redisMultiCache.setTtl(ttl);
            }
            return redisMultiCache;
        }
        throw new IllegalArgumentException("\u627e\u4e0d\u5230\u76f8\u5173\u7f13\u5b58!");
    }

    public Cache findCache(PosType posType, String cacheName) {
        return this.findCache(posType, -1, cacheName);
    }
}

