/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache;

import com.cyberway.mp.bc.cache.CacheFactory;
import com.cyberway.mp.bc.cache.CacheService;
import com.cyberway.mp.bc.cache.annotation.PosType;
import com.cyberway.mp.bc.cache.config.MultiLevelCacheProperties;
import org.springframework.lang.Nullable;

public class DefaultCacheService
implements CacheService {
    private final CacheFactory cacheFactory;
    private final MultiLevelCacheProperties multiLevelCacheProperties;

    public DefaultCacheService(CacheFactory cacheFactory, MultiLevelCacheProperties multiLevelCacheProperties) {
        this.cacheFactory = cacheFactory;
        this.multiLevelCacheProperties = multiLevelCacheProperties;
    }

    @Override
    public <T> T get(String cacheName, Object key, @Nullable Class<T> type) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        return this.get(cacheName, key, type, configPosType);
    }

    @Override
    public <T> T get(String cacheName, Object key, @Nullable Class<T> type, PosType posType) {
        if (posType.support(PosType.ALL)) {
            Object value = this.cacheFactory.findCache(PosType.LOCAL, cacheName).get(key, type);
            if (value == null) {
                return (T)this.cacheFactory.findCache(PosType.REMOTE, cacheName).get(key, type);
            }
            return (T)value;
        }
        return (T)this.cacheFactory.findCache(posType, cacheName).get(key, type);
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        this.put(cacheName, key, value, configPosType);
    }

    @Override
    public void put(String cacheName, Object key, Object value, PosType posType) {
        if (posType.support(PosType.ALL)) {
            this.cacheFactory.findCache(PosType.LOCAL, cacheName).put(key, value);
            this.cacheFactory.findCache(PosType.REMOTE, cacheName).put(key, value);
        } else {
            this.cacheFactory.findCache(posType, cacheName).put(key, value);
        }
    }

    @Override
    public void put(String cacheName, Object key, Object value, int ttl) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        this.put(cacheName, key, value, configPosType, ttl);
    }

    @Override
    public void put(String cacheName, Object key, Object value, PosType posType, int ttl) {
        if (posType.support(PosType.ALL)) {
            this.cacheFactory.findCache(PosType.LOCAL, ttl, cacheName).put(key, value);
            this.cacheFactory.findCache(PosType.REMOTE, ttl, cacheName).put(key, value);
        } else {
            this.cacheFactory.findCache(posType, ttl, cacheName).put(key, value);
        }
    }

    @Override
    public void clear(String cacheName) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        this.clear(cacheName, configPosType);
    }

    @Override
    public void clear(String cacheName, PosType posType) {
        if (posType.support(PosType.ALL)) {
            this.cacheFactory.findCache(PosType.LOCAL, cacheName).clear();
            this.cacheFactory.findCache(PosType.REMOTE, cacheName).clear();
        } else {
            this.cacheFactory.findCache(posType, cacheName).clear();
        }
    }

    @Override
    public void evict(String cacheName, Object key) {
        PosType configPosType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        this.evict(cacheName, key, configPosType);
    }

    @Override
    public void evict(String cacheName, Object key, PosType posType) {
        if (posType.support(PosType.ALL)) {
            this.cacheFactory.findCache(PosType.LOCAL, cacheName).evict(key);
            this.cacheFactory.findCache(PosType.REMOTE, cacheName).evict(key);
        } else {
            this.cacheFactory.findCache(posType, cacheName).evict(key);
        }
    }
}

