/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.cache.interceptor.SimpleKeyGenerator;

public class ObjectKeyGenerator
extends SimpleKeyGenerator {
    public static final String BEAN_NAME = "cacheObjectKeyGenerator";

    public Object generate(Object target, Method method, Object ... params) {
        return ObjectKeyGenerator.generateKey(params);
    }

    public static Object generateKey(Object ... params) {
        Object param;
        if (params.length == 0) {
            return SimpleKey.EMPTY;
        }
        if (params.length == 1 && (param = params[0]) != null && Collection.class.isAssignableFrom(param.getClass())) {
            Collection c = (Collection)param;
            return ObjectKeyGenerator.generateKey(c.toArray());
        }
        SimpleKey simpleKey = new SimpleKey(params);
        return SimpleKey.class.getSimpleName() + " [" + simpleKey.hashCode() + "]";
    }

    public static String resolveCacheName(String redisCacheName) {
        String[] redisCacheNameList = redisCacheName.split("::");
        if (redisCacheNameList.length > 2) {
            CharSequence[] newRedisCacheNameList = Arrays.copyOfRange(redisCacheNameList, 0, redisCacheNameList.length - 1);
            return String.join((CharSequence)"::", newRedisCacheNameList);
        }
        return redisCacheNameList[0];
    }
}

