/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.caffeine.CaffeineCacheManager;

public class CaffeineMultiCacheManager
extends CaffeineCacheManager {
    private Caffeine<Object, Object> cacheBuilder = Caffeine.newBuilder();
    private final Map<String, Integer> nameTTl = new ConcurrentHashMap<String, Integer>();

    public void setTTl(String name, Integer ttl) {
        this.nameTTl.putIfAbsent(name, ttl);
    }

    protected Cache<Object, Object> createNativeCaffeineCache(String name) {
        if (this.nameTTl.containsKey(name)) {
            return Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.nameTTl.get(name).intValue())).build();
        }
        return this.cacheBuilder.build();
    }
}

