/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.config;

import com.cyberway.mp.bc.cache.CacheFactory;
import com.cyberway.mp.bc.cache.CacheService;
import com.cyberway.mp.bc.cache.DefaultCacheService;
import com.cyberway.mp.bc.cache.ObjectKeyGenerator;
import com.cyberway.mp.bc.cache.config.MultiLevelCacheProperties;
import com.cyberway.mp.bc.cache.interceptor.MultiLevelCacheResolver;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration
@EnableConfigurationProperties(value={MultiLevelCacheProperties.class, CacheProperties.class})
public class MultiCacheConfig
extends CachingConfigurerSupport {
    @Bean
    public MultiLevelCacheResolver multiLevelCacheResolver() {
        return new MultiLevelCacheResolver();
    }

    @Nullable
    public CacheResolver cacheResolver() {
        return this.multiLevelCacheResolver();
    }

    @Bean
    public CacheFactory cacheFactory() {
        return new CacheFactory();
    }

    @Bean
    public CacheService cacheService(MultiLevelCacheProperties multiLevelCacheProperties, CacheFactory cacheFactory) {
        return new DefaultCacheService(cacheFactory, multiLevelCacheProperties);
    }

    @Bean(name={"cacheObjectKeyGenerator"})
    public KeyGenerator objectKeyGenerator() {
        return new ObjectKeyGenerator();
    }
}

