/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.config;

import com.cyberway.mp.bc.cache.caffeine.CaffeineMultiCacheManager;
import com.cyberway.mp.bc.cache.listener.DelLocalCacheClear;
import com.cyberway.mp.bc.cache.listener.ExpirationLocalCacheClear;
import com.cyberway.mp.bc.common.condition.ConditionalOnPropertyMutilValue;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisMultiCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnPropertyMutilValue(name="spring.multilevelcache.pos-type", havingValue={"all", "remote"})
@Import(value={RedisAutoConfiguration.class})
public class RedisCacheConfig {
    @Value(value="${spring.multilevelcache.keyspaceNotificationsConfigParameter:EA}")
    private String keyspaceNotificationsConfigParameter;

    @Bean
    public RedisMultiCacheManager redisMultiCacheManager(RedisConnectionFactory redisConnectionFactory, CacheProperties cacheProperties) {
        return RedisMultiCacheManager.create(redisConnectionFactory, this.determineConfiguration(cacheProperties));
    }

    private RedisCacheConfiguration determineConfiguration(CacheProperties cacheProperties) {
        CacheProperties.Redis redisProperties = cacheProperties.getRedis();
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        config = config.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer(objectMapper)));
        if (redisProperties.getKeyPrefix() != null) {
            config = config.prefixCacheNameWith(redisProperties.getKeyPrefix());
        }
        if (!redisProperties.isCacheNullValues()) {
            config = config.disableCachingNullValues();
        }
        if (!redisProperties.isUseKeyPrefix()) {
            config = config.disableKeyPrefix();
        }
        return config;
    }

    @Bean
    @ConditionalOnPropertyMutilValue(name="spring.multilevelcache.pos-type", havingValue={"all"})
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        return redisMessageListenerContainer;
    }

    @Bean
    @ConditionalOnPropertyMutilValue(name="spring.multilevelcache.pos-type", havingValue={"all"})
    public DelLocalCacheClear delLocalCacheClear(RedisMessageListenerContainer listenerContainer, CaffeineMultiCacheManager caffeineMultiCacheManager) {
        DelLocalCacheClear delLocalCacheClear = new DelLocalCacheClear(listenerContainer, caffeineMultiCacheManager);
        delLocalCacheClear.setKeyspaceNotificationsConfigParameter(this.keyspaceNotificationsConfigParameter);
        return delLocalCacheClear;
    }

    @Bean
    @ConditionalOnPropertyMutilValue(name="spring.multilevelcache.pos-type", havingValue={"all"})
    public ExpirationLocalCacheClear expirationLocalCacheClear(RedisMessageListenerContainer listenerContainer, CaffeineMultiCacheManager caffeineMultiCacheManager) {
        ExpirationLocalCacheClear expirationLocalCacheClear = new ExpirationLocalCacheClear(listenerContainer, caffeineMultiCacheManager);
        expirationLocalCacheClear.setKeyspaceNotificationsConfigParameter(this.keyspaceNotificationsConfigParameter);
        return expirationLocalCacheClear;
    }
}

