/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.interceptor;

import com.cyberway.mp.bc.cache.annotation.MultiLevelCachePut;
import com.cyberway.mp.bc.cache.annotation.MultiLevelCacheable;
import com.cyberway.mp.bc.cache.annotation.MultiLevelEvict;
import com.cyberway.mp.bc.cache.annotation.PosType;
import com.cyberway.mp.bc.cache.caffeine.CaffeineMultiCacheManager;
import com.cyberway.mp.bc.cache.config.MultiLevelCacheProperties;
import com.cyberway.mp.bc.cache.redis.RedisMultiCache;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.redis.cache.RedisMultiCacheManager;
import org.springframework.util.CollectionUtils;

@EnableConfigurationProperties(value={MultiLevelCacheProperties.class})
public class MultiLevelCacheResolver
implements CacheResolver,
ApplicationContextAware {
    @Autowired
    private MultiLevelCacheProperties multiLevelCacheProperties;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Collection<? extends Cache> resolveCaches(CacheOperationInvocationContext<?> context) {
        PosType posType = this.getPosType(context);
        int ttl = this.getTTl(context);
        Set cacheNames = context.getOperation().getCacheNames();
        if (CollectionUtils.isEmpty((Collection)cacheNames)) {
            return Collections.emptyList();
        }
        ArrayList<Cache> result = new ArrayList<Cache>(cacheNames.size());
        for (String cacheName : cacheNames) {
            this.addCaches(posType, ttl, cacheName, result);
        }
        return result;
    }

    private void addCaches(PosType posType, int ttl, String cacheName, Collection<Cache> result) {
        if (PosType.LOCAL.equals((Object)posType) || PosType.ALL.equals((Object)posType)) {
            CaffeineMultiCacheManager caffeineMultiCacheManager = (CaffeineMultiCacheManager)((Object)this.applicationContext.getBean(CaffeineMultiCacheManager.class));
            caffeineMultiCacheManager.setTTl(cacheName, ttl);
            Cache cache = caffeineMultiCacheManager.getCache(cacheName);
            result.add(cache);
        }
        if (PosType.REMOTE.equals((Object)posType) || PosType.ALL.equals((Object)posType)) {
            RedisMultiCacheManager redisMultiCacheManager = (RedisMultiCacheManager)((Object)this.applicationContext.getBean(RedisMultiCacheManager.class));
            RedisMultiCache redisMultiCache = (RedisMultiCache)redisMultiCacheManager.getCache(cacheName);
            if (null != redisMultiCache) {
                redisMultiCache.setTtl(ttl);
            }
            result.add((Cache)redisMultiCache);
        }
    }

    private int getTTl(CacheOperationInvocationContext<?> context) {
        int ttl = Integer.MAX_VALUE;
        if (context.getOperation() instanceof CacheableOperation) {
            ttl = context.getMethod().getAnnotation(MultiLevelCacheable.class).ttl();
        } else if (context.getOperation() instanceof CachePutOperation) {
            ttl = context.getMethod().getAnnotation(MultiLevelCachePut.class).ttl();
        }
        return ttl;
    }

    private PosType getPosType(CacheOperationInvocationContext<?> context) {
        MultiLevelEvict multiLevelEvict;
        PosType posType = PosType.strOf(this.multiLevelCacheProperties.getPosType());
        PosType metondPosType = null;
        if (context.getOperation() instanceof CacheableOperation) {
            MultiLevelCacheable multiLevelCacheable = (MultiLevelCacheable)AnnotationUtils.getAnnotation((Method)context.getMethod(), MultiLevelCacheable.class);
            if (null != multiLevelCacheable) {
                metondPosType = multiLevelCacheable.posType();
            }
        } else if (context.getOperation() instanceof CachePutOperation) {
            MultiLevelCachePut multiLevelCachePut = (MultiLevelCachePut)AnnotationUtils.getAnnotation((Method)context.getMethod(), MultiLevelCachePut.class);
            if (null != multiLevelCachePut) {
                metondPosType = multiLevelCachePut.posType();
            }
        } else if (context.getOperation() instanceof CacheEvictOperation && null != (multiLevelEvict = (MultiLevelEvict)AnnotationUtils.getAnnotation((Method)context.getMethod(), MultiLevelEvict.class))) {
            metondPosType = multiLevelEvict.posType();
        }
        if (PosType.ALL.equals((Object)posType)) {
            return metondPosType;
        }
        if (!posType.equals((Object)metondPosType)) {
            throw new IllegalArgumentException("\u5168\u5c40\u914d\u7f6e\u4e0d\u540c\u65f6\u652f\u6301\u672c\u5730\u548c\u5168\u5c40\uff0c\u6ce8\u89e3\u4f4d\u7f6e\u914d\u7f6e\u5fc5\u987b\u548c\u5168\u5c40\u914d\u7f6e\u76f8\u540c!");
        }
        return metondPosType;
    }
}

