/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.listener;

import com.cyberway.mp.bc.cache.ObjectKeyGenerator;
import com.cyberway.mp.bc.cache.caffeine.CaffeineMultiCacheManager;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cache.Cache;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.util.ReflectionUtils;

public class DelLocalCacheClear
extends KeyspaceEventMessageListener {
    private static final Topic KEYEVENT_DELETE_TOPIC = new PatternTopic("__keyevent@*__:del");
    private CaffeineMultiCacheManager caffeineMultiCacheManager;

    public DelLocalCacheClear(RedisMessageListenerContainer listenerContainer, CaffeineMultiCacheManager caffeineMultiCacheManager) {
        super(listenerContainer);
        this.caffeineMultiCacheManager = caffeineMultiCacheManager;
    }

    protected void doRegister(RedisMessageListenerContainer listenerContainer) {
        listenerContainer.addMessageListener((MessageListener)this, KEYEVENT_DELETE_TOPIC);
    }

    protected void doHandleMessage(Message message) {
        String expiredKey = message.toString();
        expiredKey = ObjectKeyGenerator.resolveCacheName(expiredKey);
        Collection cacheNames = this.caffeineMultiCacheManager.getCacheNames();
        if (cacheNames.contains(expiredKey)) {
            Field cacheMapField;
            Cache cache = this.caffeineMultiCacheManager.getCache(expiredKey);
            if (cache != null) {
                cache.clear();
            }
            if ((cacheMapField = ReflectionUtils.findField(CaffeineMultiCacheManager.class, (String)"cacheMap")) != null) {
                ReflectionUtils.makeAccessible((Field)cacheMapField);
                ConcurrentHashMap cacheMap = (ConcurrentHashMap)ReflectionUtils.getField((Field)cacheMapField, (Object)((Object)this.caffeineMultiCacheManager));
                if (cacheMap != null) {
                    cacheMap.remove(expiredKey);
                }
            }
        }
    }
}

