/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.cache.redis;

import java.time.Duration;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.Nullable;

public class RedisMultiCache
extends RedisCache {
    private Duration ttl;

    public RedisMultiCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(name, cacheWriter, cacheConfig);
    }

    public void setTtl(int seconds) {
        this.ttl = Duration.ofSeconds(seconds);
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.getName()));
        }
        this.getNativeCache().put(this.getName(), this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.ttl != null ? this.ttl : this.getCacheConfiguration().getTtl());
    }

    public Cache.ValueWrapper putIfAbsent(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            return this.get(key);
        }
        byte[] result = this.getNativeCache().putIfAbsent(this.getName(), this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.ttl != null ? this.ttl : this.getCacheConfiguration().getTtl());
        if (result == null) {
            return null;
        }
        return new SimpleValueWrapper(this.fromStoreValue(this.deserializeCacheValue(result)));
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }
}

