/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import com.cyberway.mp.bc.cache.redis.RedisMultiCache;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;

public class RedisMultiCacheManager
extends RedisCacheManager {
    private RedisCacheWriter cacheWriter;
    private RedisCacheConfiguration defaultCacheConfig;

    public RedisMultiCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        super(cacheWriter, defaultCacheConfiguration, true, new String[0]);
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
    }

    public static RedisMultiCacheManager create(RedisConnectionFactory connectionFactory, RedisCacheConfiguration defaultCacheConfiguration) {
        return new RedisMultiCacheManager(RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)connectionFactory), defaultCacheConfiguration);
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new RedisMultiCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }
}

