/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.api.enums;

import org.apache.commons.lang3.StringUtils;

public enum DataType {
    BigDecimal("\u5927\u6570\u503c\u5bf9\u8c61", "BigDecimal", "DECIMAL", "DECIMAL", "decimal"),
    Boolean("\u5e03\u5c14\u578b", "Boolean", "TINYINT(1)", "TINYINT(1)", "tinyint"),
    Date("\u65e5\u671f", "Date", "DATETIME", "DATETIME", "datetime"),
    Double("\u53cc\u7cbe\u5ea6\u5c0f\u6570", "Double", "DOUBLE", "FLOAT", "double"),
    Float("\u6d6e\u70b9\u5355\u7cbe\u5ea6\u5c0f\u6570", "Float", "FLOAT", "FLOAT", "float"),
    Integer("\u6574\u578b", "Integer", "INTEGER", "INT", "int"),
    Long("\u957f\u6574\u578b", "Long", "BIGINT", "BIGINT", "bigint"),
    Short("\u77ed\u6574\u578b", "Short", "SMALLINT", "SMALLINT", "smallint"),
    String("\u5b57\u7b26\u4e32", "String", "VARCHAR", "NVARCHAR", "varchar"),
    Text("\u957f\u5b57\u7b26\u4e32", "String", "TEXT", "NVARCHAR(MAX)", "text"),
    GEO("\u5730\u7406\u4f4d\u7f6e", "Geometry", "GEOMETRY", "GEOGRAPHY", "GEOGRAPHY");

    private final String displayName;
    private final String javaType;
    private final String mysqlType;
    private final String mssqlType;
    private final String liquibaseType;

    private DataType(String displayName, String javaType, String mysqlType, String mssqlType, String liquibaseType) {
        this.displayName = displayName;
        this.javaType = javaType;
        this.mysqlType = mysqlType;
        this.mssqlType = mssqlType;
        this.liquibaseType = liquibaseType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static DataType getByDisplayName(String displayName) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.getDisplayName().equals(displayName)) continue;
            return dataType;
        }
        return null;
    }

    public static DataType getByName(String name) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.name().equalsIgnoreCase(name)) continue;
            return dataType;
        }
        return null;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getMysqlType() {
        return this.mysqlType;
    }

    public String getMssqlType() {
        return this.mssqlType;
    }

    public String getLiquibaseType() {
        return this.liquibaseType;
    }

    public static DataType findEnum(String displayName) {
        if (StringUtils.isBlank((CharSequence)displayName)) {
            return null;
        }
        for (DataType dataType : DataType.values()) {
            if (!dataType.getDisplayName().equals(displayName)) continue;
            return dataType;
        }
        return null;
    }
}

