/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.api.exception;

import com.cyberway.mp.bc.common.api.exception.ErrorCode;

public class BaseException
extends RuntimeException {
    public static final String UNKNOWN = "00000001";
    public static final String PARAM_ERROR = "00000002";
    private static final long serialVersionUID = 1381325479896057076L;
    private final String code;
    private final Object[] errArgs;

    public String getCode() {
        return this.code;
    }

    public Object[] getErrArgs() {
        return this.errArgs;
    }

    public BaseException(Throwable cause) {
        super(cause);
        this.code = null;
        this.errArgs = null;
    }

    public BaseException(String message, Throwable cause) {
        super(message, cause);
        this.code = null;
        this.errArgs = null;
    }

    public BaseException(String code, String message) {
        super(message);
        this.code = code;
        this.errArgs = null;
    }

    public BaseException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.errArgs = null;
    }

    public BaseException(String code, String message, Throwable cause, Object ... errArgs) {
        super(BaseException.buildMessage(message, errArgs), cause);
        this.code = code;
        this.errArgs = errArgs;
    }

    public BaseException(ErrorCode errorCode) {
        this(errorCode.getCode(), errorCode.getMessage());
    }

    public BaseException(ErrorCode errorCode, Object ... errArgs) {
        this(errorCode.getCode(), errorCode.getMessage(), errArgs);
    }

    public BaseException(ErrorCode errorCode, Throwable cause, Object ... errArgs) {
        this(errorCode.getCode(), errorCode.getMessage(), cause, errArgs);
    }

    public BaseException(String code, String message, Object ... errArgs) {
        super(BaseException.buildMessage(message, errArgs));
        this.code = code;
        this.errArgs = errArgs;
    }

    public static String buildMessage(String message, Object ... errArgs) {
        if (null != message && message.length() > 0 && null != errArgs && errArgs.length > 0) {
            for (int i = 0; i < errArgs.length; ++i) {
                message = message.replace(String.format("{%s}", i), errArgs[i] == null ? "null" : errArgs[i].toString());
            }
        }
        return message;
    }
}

