/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.controller;

import com.cyberway.mp.bc.commom.code.api.CommonCreateApi;
import com.cyberway.mp.bc.commom.code.api.CommonDeleteApi;
import com.cyberway.mp.bc.commom.code.api.CommonQueryApi;
import com.cyberway.mp.bc.commom.code.api.CommonStatusApi;
import com.cyberway.mp.bc.commom.code.api.CommonUpdateApi;
import com.cyberway.mp.bc.commom.code.api.dto.req.CommonCreate;
import com.cyberway.mp.bc.commom.code.api.dto.req.CommonQuery;
import com.cyberway.mp.bc.commom.code.api.dto.req.CommonUpdate;
import com.cyberway.mp.bc.commom.code.api.dto.resp.CommonDetail;
import com.cyberway.mp.bc.commom.code.api.dto.resp.CommonList;
import com.cyberway.mp.bc.commom.code.api.enums.BasicStatus;
import com.cyberway.mp.bc.commom.code.controller.CommonQueryController;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
public class CommonController<CreateReqDto extends CommonCreate, UpdateReqDto extends CommonUpdate, QueryReqDto extends CommonQuery, DetailRespDto extends CommonDetail, ListRespDto extends CommonList>
extends CommonQueryController<QueryReqDto, DetailRespDto, ListRespDto> {
    private final CommonCreateApi commonCreateApi;
    private final CommonUpdateApi commonUpdateApi;
    private final CommonDeleteApi commonDeleteApi;
    private final CommonStatusApi commonStatusApi;

    public CommonController(CommonCreateApi commonCreateApi, CommonUpdateApi commonUpdateApi, CommonQueryApi commonQueryApi, CommonDeleteApi commonDeleteApi, CommonStatusApi commonStatusApi) {
        super(commonQueryApi);
        this.commonCreateApi = commonCreateApi;
        this.commonUpdateApi = commonUpdateApi;
        this.commonDeleteApi = commonDeleteApi;
        this.commonStatusApi = commonStatusApi;
    }

    @PostMapping(value={"/create"})
    @Operation(summary="\u65b0\u589e")
    public ResponseResult<Long> create(@Valid @RequestBody CreateReqDto createReqDto) {
        return ResponseResult.successResult((Object)this.commonCreateApi.create(createReqDto));
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u7f16\u8f91")
    public ResponseResult<Void> update(@Valid @RequestBody UpdateReqDto updateReqDto) {
        this.commonUpdateApi.update(updateReqDto);
        return ResponseResult.successResult();
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u5220\u9664")
    public ResponseResult<Void> delete(@PathVariable(value="id") Long id) {
        this.commonDeleteApi.delete(id);
        return ResponseResult.successResult();
    }

    @DeleteMapping(value={"/batchDelete"})
    @Operation(summary="\u6279\u91cf\u5220\u9664")
    public ResponseResult<Void> batchDelete(@RequestBody List<Long> ids) {
        this.commonDeleteApi.batchDelete(ids);
        return ResponseResult.successResult();
    }

    @PutMapping(value={"/status/{status}"})
    @Operation(summary="\u7981\u7528\u542f\u7528")
    public ResponseResult<Void> status(@RequestBody List<Long> ids, @PathVariable(value="status") BasicStatus status) {
        this.commonStatusApi.status(ids, status);
        return ResponseResult.successResult();
    }
}

