/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/export/template"})
@Tag(name="exportTemplate", description="\u5bfc\u51fa\u6a21\u7248")
public class ExportTemplateController {
    @Operation(summary="\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/download"})
    public ResponseEntity<Object> templateDownload(@RequestParam(value="templateName") String templateName, HttpServletResponse response) {
        ResponseEntity responseEntity;
        block11: {
            ClassPathResource resource = new ClassPathResource("template/" + templateName);
            if (!resource.exists()) {
                return ResponseEntity.badRequest().body((Object)"\u627e\u4e0d\u5230\u4e0b\u8f7d\u7684\u6a21\u677f");
            }
            ServletOutputStream os = response.getOutputStream();
            try {
                String resourceName = StringUtils.defaultString((String)resource.getFilename(), (String)"unknown.xls");
                if (resourceName.endsWith("xls")) {
                    response.setContentType("application/vnd.ms-excel");
                } else {
                    response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                }
                response.setCharacterEncoding("utf-8");
                String fileName = URLEncoder.encode(resourceName, StandardCharsets.UTF_8).replace("\\+", "%20");
                response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)os);
                responseEntity = ResponseEntity.ok().build();
                if (os == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ResponseEntity.badRequest().body((Object)e.getMessage());
                }
            }
            os.close();
        }
        return responseEntity;
    }
}

