/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/export/template"})
@Tag(name="exportTemplate", description="\u5bfc\u51fa\u6a21\u7248")
public class ExportTemplateController {
    @Operation(summary="\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/download"})
    public ResponseEntity<Object> templateDownload(@RequestParam(value="templateName") String templateName, HttpServletResponse response) {
        ResponseEntity responseEntity;
        block9: {
            ClassPathResource resource = new ClassPathResource("template/" + templateName);
            if (null == resource) {
                return ResponseEntity.badRequest().body((Object)"\u627e\u4e0d\u5230\u4e0b\u8f7d\u7684\u6a21\u677f");
            }
            ServletOutputStream os = response.getOutputStream();
            try {
                response.setContentType("application/vnd.ms-excel");
                response.setCharacterEncoding("utf-8");
                String fileName = URLEncoder.encode(resource.getFilename(), StandardCharsets.UTF_8).replace("\\+", "%20");
                response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
                IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)os);
                responseEntity = ResponseEntity.ok().build();
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return ResponseEntity.badRequest().body((Object)e.getMessage());
                }
            }
            os.close();
        }
        return responseEntity;
    }
}

