/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.domain.service;

import com.cyberway.mp.bc.commom.code.api.dto.req.CommonQueryReqDto;
import com.cyberway.mp.bc.commom.code.api.dto.req.Filter;
import com.cyberway.mp.bc.commom.code.domain.repository.CommonQueryBeanRepository;
import com.cyberway.mp.bc.commom.code.domain.repository.query.CommonQueryBean;
import com.cyberway.mp.bc.commom.code.domain.service.CommonQueryService;
import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.enums.DataType;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.dynamicquery.ColExpression;
import com.cyberway.mp.bc.dal.dynamicquery.DynamicQuery;
import com.cyberway.mp.bc.dal.dynamicquery.Expression;
import com.cyberway.mp.bc.dal.dynamicquery.ValExpression;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public abstract class CommonQueryBeanQueryService<E extends Entity, B extends CommonQueryBean, P extends PageParam, K>
extends CommonQueryService<E, K> {
    private static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};
    private CommonQueryBeanRepository<E, B, K> commonQueryBeanRepository;

    public CommonQueryBeanQueryService(CommonQueryBeanRepository<E, B, K> commonQueryBeanRepository) {
        super(commonQueryBeanRepository);
        this.commonQueryBeanRepository = commonQueryBeanRepository;
    }

    public Page<E> queryByPage(P queryReqDto) {
        B queryBean = this.getCommonQueryBean(queryReqDto);
        long count = this.commonQueryBeanRepository.countByQueryBean(queryBean);
        if (count == 0L) {
            return new Page(0, queryReqDto.getPageSize(), 0L, Collections.emptyList());
        }
        List<E> storeHistories = this.commonQueryBeanRepository.searchByQueryBean(queryBean, (PageParam)queryReqDto);
        return new Page(queryReqDto.getCurrent(), queryReqDto.getPageSize(), count, storeHistories);
    }

    public abstract B getCommonQueryBean(P var1);

    public Page<E> pageByDynamicQuery(P queryReqDto) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(queryReqDto);
        long count = this.commonQueryBeanRepository.countByDynamicQuery(dynamicQuery);
        if (count == 0L) {
            return new Page(0, queryReqDto.getPageSize(), 0L, Collections.emptyList());
        }
        List<E> entityList = this.commonQueryBeanRepository.searchPageByDynamicQuery(dynamicQuery, (PageParam)queryReqDto);
        return new Page(queryReqDto.getCurrent(), queryReqDto.getPageSize(), count, entityList);
    }

    public List<E> listByDynamicQuery(P queryReqDto) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(queryReqDto);
        return this.commonQueryBeanRepository.searchListByDynamicQuery(dynamicQuery);
    }

    public DynamicQuery buildDynamicQuery(P queryReqDto) {
        DynamicQuery dynamicQuery = new DynamicQuery();
        dynamicQuery.table(this.getTableName());
        if (queryReqDto instanceof CommonQueryReqDto) {
            OrderFragment orderFragment;
            CommonQueryReqDto commonQueryReqDto = (CommonQueryReqDto)queryReqDto;
            if (!CollectionUtils.isEmpty(commonQueryReqDto.getFilters())) {
                for (Filter filter : commonQueryReqDto.getFilters()) {
                    ColExpression col = ColExpression.col((String)filter.getField());
                    ValExpression val = ValExpression.from((Object)this.buildValue(filter));
                    switch (filter.getOperation()) {
                        case Eq: {
                            dynamicQuery.addWhere(Expression.sqlEqual((Expression)col, (Expression)val));
                            break;
                        }
                        case NotEq: {
                            dynamicQuery.addWhere(Expression.notEqual((Expression)col, (Expression)val));
                            break;
                        }
                        case StartsWith: {
                            dynamicQuery.addWhere(Expression.startingWith((Expression)col, (Expression)val));
                            break;
                        }
                        case EndsWith: {
                            dynamicQuery.addWhere(Expression.endWith((Expression)col, (Expression)val));
                            break;
                        }
                        case Contains: {
                            dynamicQuery.addWhere(Expression.contain((Expression)col, (Expression)val));
                            break;
                        }
                        case NotContains: {
                            dynamicQuery.addWhere(Expression.notContain((Expression)col, (Expression)val));
                            break;
                        }
                        case LessThan: {
                            dynamicQuery.addWhere(Expression.lessThan((Expression)col, (Expression)val));
                            break;
                        }
                        case LessThanEq: {
                            dynamicQuery.addWhere(Expression.lessThanEqual((Expression)col, (Expression)val));
                            break;
                        }
                        case GreaterThan: {
                            dynamicQuery.addWhere(Expression.greaterThan((Expression)col, (Expression)val));
                            break;
                        }
                        case GreaterThanEq: {
                            dynamicQuery.addWhere(Expression.greaterThanEqual((Expression)col, (Expression)val));
                            break;
                        }
                        case InList: {
                            dynamicQuery.addWhere(Expression.in((Expression)col, (Expression)val));
                            break;
                        }
                        case NotInList: {
                            dynamicQuery.addWhere(Expression.notIn((Expression)col, (Expression)val));
                            break;
                        }
                        case IsNull: {
                            dynamicQuery.addWhere(Expression.isNull((Expression)col));
                            break;
                        }
                        case IsNotNull: {
                            dynamicQuery.addWhere(Expression.isNotNull((Expression)col));
                            break;
                        }
                    }
                }
            }
            if (null != (orderFragment = OrderFragment.fromOrderPageParam((OrderPageParam)commonQueryReqDto))) {
                dynamicQuery.addOrder(orderFragment);
            }
        }
        return dynamicQuery;
    }

    public Object buildValue(Filter filter) {
        if (null == filter || null == filter.getValue()) {
            return null;
        }
        if (DataType.Date.equals((Object)filter.getFieldType())) {
            Calendar calendar = Calendar.getInstance();
            Object value = filter.getValue();
            Date time = value instanceof Date ? (Date)value : this.parseDate(value);
            if (time == null) {
                throw new IllegalArgumentException();
            }
            calendar.setTime(time);
            if (DataType.Date.equals((Object)filter.getFieldType())) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (Filter.Operation.GreaterThan.equals((Object)filter.getOperation()) || Filter.Operation.GreaterThanEq.equals((Object)filter.getOperation())) {
                value = calendar.getTime();
            }
            if (Filter.Operation.LessThan.equals((Object)filter.getOperation()) || Filter.Operation.LessThanEq.equals((Object)filter.getOperation())) {
                if (DataType.Date.equals((Object)filter.getFieldType()) && Filter.Operation.LessThanEq.equals((Object)filter.getOperation())) {
                    calendar.add(5, 1);
                    calendar.add(14, -1);
                }
                value = calendar.getTime();
            }
            return value;
        }
        return filter.getValue();
    }

    public String getTableName() {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (!entityClass.isAnnotationPresent(Table.class)) {
            return Strings.underscoreName((String)entityClass.getSimpleName());
        }
        Table table = (Table)AnnotationUtils.getAnnotation((AnnotatedElement)entityClass, Table.class);
        if (StringUtils.isBlank((CharSequence)table.name())) {
            return Strings.underscoreName((String)entityClass.getSimpleName());
        }
        return table.name();
    }

    private Date parseDate(Object str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str.toString(), (String[])parsePatterns);
        }
        catch (ParseException var2) {
            return null;
        }
    }
}

