/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.domain.service;

import com.cyberway.mp.bc.commom.code.domain.repository.CommonRepository;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public abstract class CommonQueryService<Entity, PrimaryKey> {
    private CommonRepository<Entity, PrimaryKey> commonRepository;

    public CommonQueryService(CommonRepository commonRepository) {
        this.commonRepository = commonRepository;
    }

    public Entity queryById(PrimaryKey id) {
        if (null == id) {
            return null;
        }
        return (Entity)this.commonRepository.findOne(id);
    }

    public List<Entity> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.commonRepository.findByIdIn(ids);
    }

    public Entity queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.commonRepository.findByCode(code);
    }

    public List<Entity> listByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return this.commonRepository.findByCodeIn(codes);
    }
}

