/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.commom.code.domain.service;

import com.cyberway.mp.bc.commom.code.api.enums.BasicStatus;
import com.cyberway.mp.bc.commom.code.domain.repository.CommonRepository;
import com.cyberway.mp.bc.dal.model.Entity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class CommonService<Entity extends Entity, PrimaryKey> {
    private CommonRepository<Entity, PrimaryKey> commonRepository;

    public CommonService(CommonRepository commonRepository) {
        this.commonRepository = commonRepository;
    }

    @Transactional(rollbackFor={Exception.class})
    public Entity save(Entity entity) {
        this.commonRepository.save(entity);
        return entity;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrimaryKey modify(Entity entity) {
        this.commonRepository.updateById(entity, entity.getId());
        return (PrimaryKey)entity.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public List<? extends Entity> batchSave(List<? extends Entity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        this.commonRepository.batchInsert(entities);
        return entities;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(PrimaryKey id) {
        this.commonRepository.delete(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(Collection<PrimaryKey> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.commonRepository.deleteByIdIn(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateStatusByIds(Collection<Long> ids, BasicStatus status) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.commonRepository.updateStatusByIdIn(ids, status);
    }
}

