/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.config;

import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;

@Configuration
@ConditionalOnProperty(prefix="mp.common.async", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class AsyncExecutorConfiguration
implements AsyncConfigurer {
    @Value(value="${mp.common.async.corePoolSize:2}")
    private int corePoolSize;
    @Value(value="${mp.common.async.maxPoolSize:8}")
    private int maxPoolSize;
    @Value(value="${mp.common.async.keepAliveSeconds:120}")
    private int keepAliveSeconds;
    @Value(value="${mp.common.async.keepAliveSeconds:16}")
    private int queueCapacity;

    public Executor getAsyncExecutor() {
        return TtlExecutors.getTtlExecutor((Executor)new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, (long)this.keepAliveSeconds, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueCapacity), new DefaultAsyncThreadFactory()));
    }

    public static class DefaultAsyncThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("Default-Async-Thread");
            return thread;
        }
    }
}

