/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.config;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.constant.CommonErrorCode;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.lang.NonNull;

@Configuration
@ConditionalOnBean(value={RedisProperties.class})
public class LettuceDefaultConfiguration
implements ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    @Value(value="${spring.redis.tcp-user-timeout-seconds:30}")
    private int tcpUserTimeoutSeconds;
    @Value(value="${spring.redis.keepalive.idle-seconds:30}")
    private int keepAliveIdleSeconds;
    @Value(value="${spring.redis.custom-ssl.enabled:false}")
    private boolean enableCustomSsl;
    @Value(value="${spring.redis.custom-ssl.trust-store-resource-path:}")
    private String customSslTrustStoreResourcePath;
    @Value(value="${spring.redis.custom-ssl.trust-store-password:}")
    private String customSslTrustStorePassword;
    @Value(value="${spring.redis.custom-ssl.disable-peer-verification:false}")
    private boolean customSslDisablePeerVerification;

    @Bean
    @ConditionalOnMissingBean
    public LettuceClientConfigurationBuilderCustomizer clientConfigurationBuilderCustomizer() {
        return clientConfigurationBuilder -> {
            SocketOptions socketOptions = SocketOptions.builder().keepAlive(SocketOptions.KeepAliveOptions.builder().enable().idle(Duration.ofSeconds(this.keepAliveIdleSeconds)).interval(Duration.ofSeconds(this.keepAliveIdleSeconds / 3)).build()).tcpUserTimeout(SocketOptions.TcpUserTimeoutOptions.builder().enable().tcpUserTimeout(Duration.ofSeconds(this.tcpUserTimeoutSeconds)).build()).build();
            ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder().socketOptions(socketOptions).autoReconnect(true).disconnectedBehavior(ClientOptions.DisconnectedBehavior.DEFAULT);
            this.initCustomSslConfig(clientConfigurationBuilder, clientOptionsBuilder);
            clientConfigurationBuilder.clientOptions(clientOptionsBuilder.build());
        };
    }

    private void initCustomSslConfig(LettuceClientConfiguration.LettuceClientConfigurationBuilder clientConfigurationBuilder, ClientOptions.Builder clientOptionsBuilder) {
        if (!this.enableCustomSsl) {
            return;
        }
        if (this.customSslDisablePeerVerification) {
            clientConfigurationBuilder.useSsl().disablePeerVerification();
        } else {
            clientConfigurationBuilder.useSsl();
        }
        if (StringUtils.isNotBlank((CharSequence)this.customSslTrustStoreResourcePath)) {
            try {
                Resource resource = this.resourceLoader.getResource(this.customSslTrustStoreResourcePath);
                SslOptions.Builder sslOptionsBuilder = SslOptions.builder().jdkSslProvider();
                if (StringUtils.isNotBlank((CharSequence)this.customSslTrustStorePassword)) {
                    sslOptionsBuilder.truststore(resource.getURL(), this.customSslTrustStorePassword);
                } else {
                    sslOptionsBuilder.truststore(resource.getURL());
                }
                clientOptionsBuilder.sslOptions(sslOptionsBuilder.build());
            }
            catch (Exception e) {
                throw new BaseException((ErrorCode)CommonErrorCode.READ_TRUST_STORE_FILE_FAILED, (Throwable)e, new Object[0]);
            }
        }
    }

    public void setResourceLoader(@NonNull ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

