/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringValueResolver;

@Configuration(value="mpSpringContextUtil")
public class SpringContextUtil
implements ApplicationContextAware,
EmbeddedValueResolverAware {
    private static Logger logger = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext applicationContext;
    private static StringValueResolver stringValueResolver;

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> tClass) throws BeansException {
        return (T)applicationContext.getBean(tClass);
    }

    public static String getPropertiesValue(String name) {
        try {
            return stringValueResolver.resolveStringValue(name);
        }
        catch (Exception e) {
            logger.error(String.format("\u5f53\u524d\u73af\u5883\u53d8\u91cf\u4e2d\u6ca1\u6709{%s}\u7684\u914d\u7f6e", name));
            return null;
        }
    }

    public void setEmbeddedValueResolver(StringValueResolver stringValueResolver) {
        SpringContextUtil.stringValueResolver = stringValueResolver;
    }
}

