/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.cyberway.mp.bc.common.context.ServiceConstants;
import com.cyberway.mp.bc.common.context.micorservice.MicroServiceContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ServiceContext
implements ServiceConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceContext.class);
    private static final ThreadLocal<ServiceContext> LOCAL = new TransmittableThreadLocal<ServiceContext>(){

        protected ServiceContext initialValue() {
            return new ServiceContext();
        }
    };
    private final Map<String, Object> mapValue;
    private final AtomicReference<MicroServiceContext> microServiceContext = new AtomicReference();

    private ServiceContext() {
        this.mapValue = new ConcurrentHashMap<String, Object>();
    }

    public static ServiceContext getContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    private MicroServiceContext getMicroServiceContext() {
        if (this.microServiceContext.get() == null) {
            String className = "com.cyberway.mp.bc.common.context.micorservice.SpringCloudMicroServiceContext";
            try {
                this.microServiceContext.set((MicroServiceContext)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.microServiceContext.get();
    }

    public void removeAttachmentContext() {
        if (this.microServiceContext.get() != null) {
            this.microServiceContext.get().removeContext();
        }
    }

    private String convertKey(String key) {
        return key == null ? null : key.toLowerCase();
    }

    public void set(String key, Object value) {
        if (value == null) {
            this.mapValue.remove(this.convertKey(key));
        } else {
            this.mapValue.put(this.convertKey(key), value);
        }
    }

    public void remove(String key) {
        this.mapValue.remove(this.convertKey(key));
    }

    public Object get(String key) {
        return this.mapValue.get(this.convertKey(key));
    }

    public Map<String, Object> getKeys() {
        return this.mapValue;
    }

    public void setAttachment(String key, String attachment) {
        this.set(key, attachment);
        this.getMicroServiceContext().setAttachment(key, attachment);
    }

    public void setAttachment(String key, Object attachment) {
        this.set(key, attachment);
        this.getMicroServiceContext().setAttachment(key, attachment);
    }

    public void setAttachment(Map<String, Object> attachmentMap) {
        if (attachmentMap == null || attachmentMap.isEmpty()) {
            return;
        }
        attachmentMap.forEach(this::set);
    }

    public String getAttachment(String key) {
        String value = (String)this.get(key);
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment(key);
        }
        return value;
    }

    public void removeAttachment(String key) {
        this.remove(key);
        this.getMicroServiceContext().removeAttachment(key);
    }

    public Map<String, Object> getAttachments() {
        return this.getMicroServiceContext().getAttachments();
    }

    public String getAppId() {
        String value = (String)this.get("appId");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("appId");
        }
        return value;
    }

    public void setAppId(String appId) {
        this.set("appId", appId);
        this.getMicroServiceContext().setAttachment("appId", appId);
    }

    public String getAppSecret() {
        String value = (String)this.get("appSecret");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("appSecret");
        }
        return value;
    }

    public void setAppSecret(String appSecret) {
        this.set("golden.appSecret", appSecret);
        this.getMicroServiceContext().setAttachment("appSecret", appSecret);
    }

    public Long getRequestApplicationId() {
        String applicationId = (String)this.get("req.applicationId");
        if (applicationId == null) {
            applicationId = (String)this.getMicroServiceContext().getAttachment("req.applicationId");
        }
        return StringUtils.isEmpty((CharSequence)applicationId) ? null : Long.valueOf(applicationId);
    }

    public String getRequestTraceId() {
        String value = (String)this.get("req.traceId");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.traceId");
        }
        return value;
    }

    public Long getRequestUserId() {
        String userId = (String)this.get("req.userId");
        if (userId == null) {
            userId = (String)this.getMicroServiceContext().getAttachment("req.userId");
        }
        return userId != null ? Long.valueOf(userId) : null;
    }

    public String getRequestUserName() {
        String userName = (String)this.get("req.userName");
        if (userName == null) {
            userName = (String)this.getMicroServiceContext().getAttachment("req.userName");
        }
        return userName != null ? userName : null;
    }

    public String getRequestUserLoginName() {
        String loginName = (String)this.get("req.user.loginName");
        if (loginName == null) {
            loginName = (String)this.getMicroServiceContext().getAttachment("req.user.loginName");
        }
        return loginName != null ? loginName : null;
    }

    public String getRequestUserRealName() {
        String userRealName = (String)this.get("req.user.name");
        if (userRealName == null) {
            userRealName = (String)this.getMicroServiceContext().getAttachment("req.user.name");
        }
        return userRealName != null ? userRealName : null;
    }

    public String getRequestUserCode() {
        String value = (String)this.get("req.userCode");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.userCode");
        }
        return value;
    }

    public String getRequestMobile() {
        String value = (String)this.get("req.mobile");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.mobile");
        }
        return value;
    }

    public String getRequestOpenId() {
        String value = (String)this.get("req.userCode");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.openId");
        }
        return value;
    }

    public Long getRequestTenantId() {
        String tenantId = (String)this.get("req.tenantId");
        if (tenantId == null) {
            tenantId = (String)this.getMicroServiceContext().getAttachment("req.tenantId");
        }
        return StringUtils.isEmpty((CharSequence)tenantId) ? null : Long.valueOf(tenantId);
    }

    public Long getRequestAppInstanceId() {
        String appInstanceId = (String)this.get("req.appInstanceId");
        if (appInstanceId == null) {
            appInstanceId = (String)this.getMicroServiceContext().getAttachment("req.appInstanceId");
        }
        return StringUtils.isEmpty((CharSequence)appInstanceId) ? null : Long.valueOf(appInstanceId);
    }

    public Long getRequestBusinessZoneId() {
        String value = (String)this.get("req.businessZoneId");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.businessZoneId");
        }
        return StringUtils.isEmpty((CharSequence)value) ? null : Long.valueOf(value);
    }

    public String getRequestBackUrl() {
        String value = (String)this.get("req.backUrl");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.backUrl");
        }
        return value;
    }

    public String getRequestFrontView() {
        String value = (String)this.get("req.frontView");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.frontView");
        }
        return value;
    }

    public String getRequestFrontMenu() {
        String value = (String)this.get("req.frontMenu");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.frontMenu");
        }
        return value;
    }

    public String getRequestFrontRoute() {
        String value = (String)this.get("req.frontRoute");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.frontRoute");
        }
        return value;
    }

    public String getRequestId() {
        String reqId = (String)this.get("req.requestId");
        if (reqId == null) {
            reqId = (String)this.getMicroServiceContext().getAttachment("req.requestId");
        }
        return reqId;
    }

    public void setRequestId(String requestId) {
        this.set("req.requestId", requestId);
        this.getMicroServiceContext().setAttachment("req.requestId", requestId);
        MDC.put((String)"req.requestId", (String)requestId);
    }

    public String getRemoteIp() {
        String value = (String)this.get("req.remoteIp");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.remoteIp");
        }
        return value;
    }

    public String getDeviceId() {
        String value = (String)this.get("req.deviceId");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.deviceId");
        }
        return value;
    }

    public String getRequestToken() {
        String value = (String)this.get("req.token");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.token");
        }
        return value;
    }

    public String getRequestLang() {
        String value = (String)this.get("req.lang");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.lang");
        }
        return value;
    }

    public String getAppKey() {
        String value = (String)this.get("auth-app-key");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("auth-app-key");
        }
        return value;
    }

    public Boolean getRetryFlag() {
        String value = (String)this.get("req.retryFlag");
        if (value == null) {
            value = (String)this.getMicroServiceContext().getAttachment("req.retryFlag");
        }
        return Boolean.parseBoolean(value);
    }
}

