/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.controller;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ValidationException;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseResult<String> jsonErrorHandler(Exception e, HttpServletResponse response) {
        ResponseResult<String> failResult = ResponseResult.failResult();
        failResult.setMsg(e.getMessage());
        String exceptionClassName = e.getClass().getName();
        int httpStatus = HttpStatus.INTERNAL_SERVER_ERROR.value();
        if (e instanceof BaseException) {
            this.logExceptionMessage(e);
            failResult.setErrorCode(((BaseException)e).getCode());
        } else if (e instanceof HttpRequestMethodNotSupportedException) {
            failResult.setMsg("\u8be5\u65b9\u6cd5\u4e0d\u80fd\u4f7f\u7528\u8fd9\u79cd\u8bf7\u6c42\u65b9\u5f0f\uff0c\u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000001");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.METHOD_NOT_ALLOWED.value();
        } else if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException miss = (MissingServletRequestParameterException)e;
            failResult.setMsg("\u8be5\u65b9\u6cd5\u8c03\u7528\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570 " + miss.getParameterName() + ", \u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof HttpMessageNotReadableException) {
            failResult.setMsg("\u8be5\u65b9\u6cd5\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof HttpMediaTypeNotSupportedException) {
            failResult.setMsg("\u8be5\u65b9\u6cd5Content-Type\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof MissingServletRequestPartException) {
            failResult.setMsg("\u6240\u9700\u7684\u8bf7\u6c42\u90e8\u5206\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof BindException) {
            failResult.setMsg("\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof MaxUploadSizeExceededException) {
            failResult.setMsg("\u4e0a\u4f20\u6587\u4ef6\u8fc7\u5927\uff0c\u8bf7\u6309\u7167\u6587\u6863\u8c03\u7528");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof ValidationException) {
            failResult.setMsg("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25, \u6821\u9a8c\u5931\u8d25\u4fe1\u606f: " + e.getMessage());
            failResult.setErrorCode("00000002");
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof org.springframework.validation.BindException) {
            FieldError fieldError = Objects.requireNonNull(((org.springframework.validation.BindException)e).getBindingResult().getFieldError());
            failResult.setMsg("\u8bf7\u6c42\u53c2\u6570\u6821\u9a8c\u5931\u8d25, \u6821\u9a8c\u5931\u8d25\u4fe1\u606f: " + fieldError.getField() + fieldError.getDefaultMessage());
            failResult.setErrorCode("00000002");
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (e instanceof BadSqlGrammarException) {
            failResult.setMsg("\u7cfb\u7edf\u5185\u90e8SQL\u9519\u8bef");
            failResult.setErrorCode("00000002");
            this.logExceptionMessage(e);
            httpStatus = HttpStatus.BAD_REQUEST.value();
        } else if (exceptionClassName.endsWith("MyBatisSystemException")) {
            httpStatus = this.handleMyBatisSystemException(e, failResult);
        } else if (e instanceof RuntimeException) {
            if (exceptionClassName.startsWith("org.springframework.dao") || exceptionClassName.startsWith("org.springframework.jdbc")) {
                failResult.setMsg("\u7cfb\u7edf\u5185\u90e8\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
                failResult.setErrorCode("00000002");
                this.logExceptionMessage(e);
                httpStatus = HttpStatus.BAD_REQUEST.value();
            } else {
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
                if (rootCause instanceof BaseException) {
                    this.logExceptionMessage(rootCause);
                    failResult.setErrorCode(((BaseException)rootCause).getCode());
                    failResult.setMsg(rootCause.getMessage());
                } else {
                    failResult.setMsg(e.getMessage());
                    failResult.setErrorCode("00000002");
                    this.logExceptionMessage(e);
                    httpStatus = HttpStatus.BAD_REQUEST.value();
                }
            }
        } else {
            failResult.setMsg("\u7cfb\u7edf\u5185\u90e8\u9519\u8bef");
            failResult.setErrorCode("00000001");
            this.logExceptionMessage(e);
        }
        response.setStatus(httpStatus);
        return failResult;
    }

    private int handleMyBatisSystemException(Exception e, ResponseResult<String> failResult) {
        if (null != e.getCause() && e.getCause().getClass().getName().endsWith("TooManyResultsException")) {
            failResult.setMsg("\u67e5\u8be2\u5230\u591a\u6761\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        }
        failResult.setErrorCode("00000002");
        this.logExceptionMessage(e);
        return HttpStatus.BAD_REQUEST.value();
    }

    private void logExceptionMessage(Throwable throwable) {
        logger.error("GlobalExceptionHandler handle exception:", throwable);
    }
}

