/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.controller;

import com.cyberway.mp.bc.common.controller.serializer.BigNumberFieldSerializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class JacksonNumberMapperBuilderCustomizer
implements Jackson2ObjectMapperBuilderCustomizer {
    @Value(value="${mp.bc.ignore-jackson-num-packages:}")
    private List<String> ignorePackages;

    public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        BigNumberFieldSerializer serializer = this.ignorePackages == null ? BigNumberFieldSerializer.INSTANCE : new BigNumberFieldSerializer(this.ignorePackages);
        jacksonObjectMapperBuilder.serializerByType(Long.TYPE, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(Long.class, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(Double.TYPE, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(Double.class, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(Float.TYPE, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(Float.class, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(BigDecimal.class, (JsonSerializer)serializer);
        jacksonObjectMapperBuilder.serializerByType(BigInteger.class, (JsonSerializer)serializer);
    }

    public void setIgnorePackages(List<String> ignorePackages) {
        this.ignorePackages = ignorePackages;
    }
}

