/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.controller.deserializer;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongFieldDeserializer
extends StdDeserializer<Long> {
    private static final Long INVALID_LONG_VALUE = -99999L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LongFieldDeserializer.class);
    public static final LongFieldDeserializer INSTANCE = new LongFieldDeserializer();

    protected LongFieldDeserializer() {
        super(Long.class);
    }

    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        String valueStr = p.getText();
        if (StringUtils.isEmpty((CharSequence)valueStr)) {
            return null;
        }
        long value = INVALID_LONG_VALUE;
        try {
            value = Long.parseLong(valueStr);
        }
        catch (Exception e) {
            LOGGER.error("long\u5185\u5bb9[{}]\u89e3\u6790\u9519\u8bef, \u5df2\u66ff\u6362\u4e3a\uff1a[{}]", (Object)valueStr, (Object)INVALID_LONG_VALUE);
        }
        return value;
    }
}

