/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.controller.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class BigNumberFieldSerializer
extends StdSerializer<Object> {
    public static final BigNumberFieldSerializer INSTANCE = new BigNumberFieldSerializer();
    private final List<String> ignorePackages;

    public BigNumberFieldSerializer() {
        this(Collections.emptyList());
    }

    public BigNumberFieldSerializer(List<String> ignorePackages) {
        super(Object.class);
        this.ignorePackages = ignorePackages;
    }

    public String valueToString(Object value) {
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value).toPlainString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue()).toPlainString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.ignore(gen) && value instanceof Number) {
            NumberSerializer.instance.serialize((Number)value, gen, provider);
            return;
        }
        gen.writeString(this.valueToString(value));
    }

    private boolean ignore(JsonGenerator gen) {
        if (this.ignorePackages.isEmpty()) {
            return false;
        }
        JsonStreamContext context = gen.getOutputContext();
        if (context == null) {
            return false;
        }
        while (context.getParent() != null && context.getParent().getCurrentValue() != null) {
            context = context.getParent();
        }
        Object currentValue = context.getCurrentValue();
        if (currentValue == null) {
            return false;
        }
        String packageName = currentValue.getClass().getPackage().getName();
        for (String ignorePackage : this.ignorePackages) {
            if (!packageName.equals(ignorePackage) && !packageName.startsWith(ignorePackage + ".")) continue;
            return true;
        }
        return false;
    }
}

