/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto;

import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.constant.CommonErrorCode;
import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.CryptoType;
import com.cyberway.mp.bc.common.crypto.NoneCryptoProvider;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricCryptoProvider;
import com.cyberway.mp.bc.common.crypto.custom.CryptoCustomConfig;
import com.cyberway.mp.bc.common.crypto.digest.DigestCryptoProvider;
import com.cyberway.mp.bc.common.crypto.symmetric.SymmetricCryptoProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public class CryptoProviderFactory {
    private CryptoProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static CryptoProvider build(CryptoConfig config) {
        CryptoType cryptoType = CryptoType.fromName(config.getType());
        if (null == cryptoType) {
            throw new IllegalArgumentException("Unknown crypto type: " + config.getType());
        }
        switch (cryptoType) {
            case DIGEST: {
                return new DigestCryptoProvider(config.getDigest());
            }
            case SYMMETRIC: {
                return new SymmetricCryptoProvider(config.getSymmetric());
            }
            case ASYMMETRIC: {
                return new AsymmetricCryptoProvider(config.getAsymmetric());
            }
            case NONE: {
                return new NoneCryptoProvider();
            }
            case CUSTOM: {
                return CryptoProviderFactory.generateCustomCryptoProvider(config.getCustom());
            }
        }
        throw new UnsupportedOperationException("Not supported crypto type for [" + config.getType() + "] yet.");
    }

    private static CryptoProvider generateCustomCryptoProvider(CryptoCustomConfig customConfig) {
        AssertUtil.notBlank((String)customConfig.getProviderClassName(), (ErrorCode)CommonErrorCode.EMPTY_VALUE, (Object[])new Object[]{"providerClassName"});
        try {
            Class<?> providerClass = Class.forName(customConfig.getProviderClassName());
            Object provider = null;
            try {
                Constructor declaredConstructor = ReflectionUtils.accessibleConstructor(providerClass, (Class[])new Class[]{Map.class});
                provider = declaredConstructor.newInstance(customConfig.getProviderConfig());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (null == provider) {
                provider = ReflectionUtils.accessibleConstructor(providerClass, (Class[])new Class[0]).newInstance(new Object[0]);
            }
            return provider;
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
            throw new BaseException((ErrorCode)CommonErrorCode.BASE, new Object[]{":generateCustomCryptoProvider error!"});
        }
    }
}

