/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.common.crypto.asymmetric;

import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoType;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricAlgorithmType;
import org.bouncycastle.crypto.engines.SM2Engine;

public class AsymmetricConfig {
    private String asymmetricAlgorithm = AsymmetricAlgorithmType.RSA.name();
    private String sm2Mode = SM2Engine.Mode.C1C3C2.name();
    private String publicKeyBase64;
    private String privateKeyBase64;

    public String getPublicKeyBase64() {
        return this.publicKeyBase64;
    }

    public void setPublicKeyBase64(String publicKeyBase64) {
        this.publicKeyBase64 = publicKeyBase64;
    }

    public String getPrivateKeyBase64() {
        return this.privateKeyBase64;
    }

    public void setPrivateKeyBase64(String privateKeyBase64) {
        this.privateKeyBase64 = privateKeyBase64;
    }

    public String getAsymmetricAlgorithm() {
        return this.asymmetricAlgorithm;
    }

    public void setAsymmetricAlgorithm(String asymmetricAlgorithm) {
        this.asymmetricAlgorithm = asymmetricAlgorithm;
    }

    public String getSm2Mode() {
        return this.sm2Mode;
    }

    public void setSm2Mode(String sm2Mode) {
        this.sm2Mode = sm2Mode;
    }

    public static final class ConfigBuilder {
        private String asymmetricAlgorithm;
        private String sm2Mode;
        private String publicKeyBase64;
        private String privateKeyBase64;

        public ConfigBuilder asymmetricAlgorithm(String asymmetricAlgorithm) {
            this.asymmetricAlgorithm = asymmetricAlgorithm;
            return this;
        }

        public ConfigBuilder sm2Mode(String sm2Mode) {
            this.sm2Mode = sm2Mode;
            return this;
        }

        public ConfigBuilder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public ConfigBuilder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public CryptoConfig build() {
            AsymmetricConfig asymmetricConfig = new AsymmetricConfig();
            asymmetricConfig.setAsymmetricAlgorithm(this.asymmetricAlgorithm);
            asymmetricConfig.setSm2Mode(this.sm2Mode);
            asymmetricConfig.setPublicKeyBase64(this.publicKeyBase64);
            asymmetricConfig.setPrivateKeyBase64(this.privateKeyBase64);
            CryptoConfig config = new CryptoConfig();
            config.setType(CryptoType.ASYMMETRIC.name());
            config.setAsymmetric(asymmetricConfig);
            return config;
        }
    }
}

